/*
 * Decompiled with CFR 0.152.
 */
package rapture.plugin.validators;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import rapture.common.RaptureURI;
import rapture.common.dp.Step;
import rapture.common.dp.Transition;
import rapture.common.dp.Workflow;
import rapture.plugin.validators.JsonValidator;
import rapture.plugin.validators.Note;
import rapture.plugin.validators.Validator;

public class WorkflowValidator
extends JsonValidator<Workflow> {
    public static final Validator singleton = new WorkflowValidator(Workflow.class);

    public static Validator getValidator() {
        return singleton;
    }

    public WorkflowValidator(Class<Workflow> clazz) {
        super(clazz);
    }

    @Override
    void validateObject(Workflow thing, RaptureURI uri, List<Note> errors) {
        if (!thing.getWorkflowURI().equals(uri.toString())) {
            errors.add(new Note(Note.Level.ERROR, "Mismatched URI " + thing.getWorkflowURI() + " in " + uri.toString()));
        }
        HashMap name2step = Maps.newHashMap();
        for (Step step : thing.getSteps()) {
            Step old = name2step.put(step.getName(), step);
            if (old == null) continue;
            errors.add(new Note(Note.Level.ERROR, "Duplicate step name " + step.getName() + " in workflow " + uri.toString()));
        }
        for (Step step : thing.getSteps()) {
            for (Transition t : step.getTransitions()) {
                Step targetStep;
                String target = t.getTargetStep();
                if (target.startsWith("$") || (targetStep = (Step)name2step.get(target)) != null) continue;
                errors.add(new Note(Note.Level.ERROR, "Transition from step " + step.getName() + " to non-extant step " + target));
            }
        }
    }

    @Override
    void validateRaw(String content, RaptureURI uri, List<Note> errors) {
    }
}

