/**
 * Copyright (C) 2011-2015 Incapture Technologies LLC
 *
 * This is an autogenerated license statement. When copyright notices appear below
 * this one that copyright supercedes this statement.
 *
 * Unless required by applicable law or agreed to in writing, software is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 *
 * Unless explicit permission obtained in writing this software cannot be distributed.
 */
package rapture.postgres;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;

/**
 * Some helper methods
 *
 * @author alanmoore
 */
public class PostgresHelper {
    private static Logger log = Logger.getLogger(PostgresHelper.class);

    public static boolean tableExists(NamedParameterJdbcTemplate namedParameterJdbcTemplate, String tableName) throws PostgresException {
        String sql = "SELECT EXISTS (\n"
                + "    SELECT 1 \n"
                + "    FROM   pg_catalog.pg_class c\n"
                + "    JOIN   pg_catalog.pg_namespace n ON n.oid = c.relnamespace\n"
                + "    WHERE  n.nspname = 'public'\n"
                + "    AND    c.relname = :table_name\n"
                + ")";

        SqlParameterSource paramSource = new MapSqlParameterSource("table_name", tableName);
        try {
            return namedParameterJdbcTemplate.queryForObject(sql, paramSource, Boolean.class);
        } catch (DataAccessException e) {
            throw new PostgresException(String.format("Error while checking if table [%s] exists", tableName), e);
        }
    }
}
