/**
 * Copyright (C) 2011-2015 Incapture Technologies LLC
 *
 * This is an autogenerated license statement. When copyright notices appear below
 * this one that copyright supercedes this statement.
 *
 * Unless required by applicable law or agreed to in writing, software is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 *
 * Unless explicit permission obtained in writing this software cannot be distributed.
 */
package rapture.postgres;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class TemplateLoader {
	   private static Map<String, String> cachedStrings = new HashMap<String, String>();
	   public static String getResourceAsString(String path) {
		   if (cachedStrings.containsKey(path)) {
			   return cachedStrings.get(path);
		   }
	        InputStream is = TemplateLoader.class.getResourceAsStream(path);
	        if (is != null) {
	            Writer writer = new StringWriter();
	            char[] buffer = new char[1024];
	            try {
	                Reader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
	                int n;
	                while ((n = reader.read(buffer)) != -1) {
	                    writer.write(buffer, 0, n);
	                }
	            } catch (Exception e) {
	                throw new RuntimeException(e);
	            } finally {
	                try {
	                    is.close();
	                } catch (IOException e) {
	                    throw new RuntimeException(e);
	                }
	            }
	            String ret = writer.toString();
	            cachedStrings.put(path, ret);
	            return ret;
	        } else {
	            return "";
	        }

	    }

}
