/**
 * Copyright (C) 2011-2015 Incapture Technologies LLC
 *
 * This is an autogenerated license statement. When copyright notices appear below
 * this one that copyright supercedes this statement.
 *
 * Unless required by applicable law or agreed to in writing, software is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 *
 * Unless explicit permission obtained in writing this software cannot be distributed.
 */
package rapture.repo.postgres;

import org.apache.commons.lang3.StringUtils;

/**
 * @author bardhi
 * @since 3/26/15.
 */
public class PostgresSanitizer {
    private String quote;

    public PostgresSanitizer(String quote) {
        this.quote = quote;
    }

    public String sanitizeTableName(String unsanitized) {
        return StringUtils.lowerCase(unsanitized.replace(quote, ""));
    }

    public String sanitizeIndexName(String unsanitized) {
        return StringUtils.lowerCase(unsanitized.replace(quote, ""));
    }
}
