/**
 * Copyright (C) 2011-2015 Incapture Technologies LLC
 *
 * This is an autogenerated license statement. When copyright notices appear below
 * this one that copyright supercedes this statement.
 *
 * Unless required by applicable law or agreed to in writing, software is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
 * or implied.
 *
 * Unless explicit permission obtained in writing this software cannot be distributed.
 */
package rapture.repo.postgres;

import java.io.IOException;
import java.util.Map;

import org.apache.ddlutils.Platform;
import org.apache.ddlutils.model.Column;
import org.apache.ddlutils.model.Table;
import org.apache.ddlutils.platform.SqlBuilder;
import org.apache.ddlutils.platform.postgresql.PostgreSqlBuilder;

import rapture.structured.LowerCaseConverter;
import rapture.structured.StandardSqlGenerator;

public class PostgresSqlGenerator extends StandardSqlGenerator {

    public PostgresSqlGenerator() {
        super.setCaseConverter(new LowerCaseConverter());
    }

    @Override
    public String constructUpdateTableColumns(String schema, String table, Map<String, String> columns) {
        return String.format("ALTER TABLE %s %s", getSafeFullName(schema, table), getColumnExpression("ALTER COLUMN %s TYPE %s", columns));
    }

    @Override
    public String constructRenameTableColumns(String schema, String table, Map<String, String> columns) {
        return String.format("ALTER TABLE %s %s", getSafeFullName(schema, table), getColumnExpression("RENAME COLUMN %s TO %s", columns));
    }

    @Override
    public String constructGetIndexes(String schema, String table) {
        return String.format("SELECT indexname, indexdef FROM pg_indexes WHERE schemaname='%s' and tablename='%s'", schema, table);
    }

    @Override
    protected SqlBuilder getDdlSqlBuilder(final String schema, Platform platform) {
        return new PostgreSqlBuilder(platform) {
            @Override
            public String getTableName(Table table) {
                return getSafeFullName(schema, super.getTableName(table));
            }

            @Override
            public void dropTable(Table table) throws IOException {
                print("DROP TABLE IF EXISTS ");
                printIdentifier(getTableName(table));
                print(" CASCADE");
                printEndOfStatement();

                Column[] columns = table.getAutoIncrementColumns();

                for (int idx = 0; idx < columns.length; idx++)
                {
                    dropAutoIncrementSequence(table, columns[idx]);
                }
            }

            /**
             * Creates the auto-increment sequence that is then used in the column.
             *
             * @param table
             *            The table
             * @param column
             *            The column
             */
            private void dropAutoIncrementSequence(Table table, Column column) throws IOException
            {
                print("DROP SEQUENCE ");
                printIdentifier(getConstraintName(null, table, column.getName(), "seq"));
                printEndOfStatement();
            }
        };
    }
}
