--
-- Copyright (C) 2011-2015 Incapture Technologies LLC
--
-- This is an autogenerated license statement. When copyright notices appear below
-- this one that copyright supercedes this statement.
--
-- Unless required by applicable law or agreed to in writing, software is distributed
-- on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express
-- or implied.
--
-- Unless explicit permission obtained in writing this software cannot be distributed.
--

DO $$
DECLARE countExisting INTEGER;
BEGIN

IF NOT EXISTS (
    SELECT 1
    FROM   pg_class tc
    JOIN   pg_namespace n ON n.oid = tc.relnamespace
    JOIN   pg_index i ON tc.oid = i.indrelid
    JOIN   pg_class ic ON i.indexrelid = ic.oid
    WHERE  tc.relname = '%2$s'
    AND    n.nspname = 'public'
    AND    ic.relname = '%1$s'
    ) THEN

    SELECT INTO countExisting COUNT(key) from %2$s;
    IF (countExisting < %4$s) THEN
        CREATE INDEX %1$s on %2$s (%3$s);
    END IF;

END IF;

END$$
