/*
 * Decompiled with CFR 0.152.
 */
package rapture.common;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class MemUse {
    MemoryUsage heap = null;
    MemoryUsage nonheap = null;
    String marker;
    Date date;
    SimpleDateFormat simple = new SimpleDateFormat("M/dd h:mm:ss");
    boolean verbose = false;
    private static final String[] suffix = new String[]{"bytes", "kb", "Mb", "Gb", "Tb", "Pb", "Eb"};
    private static final double KILOBYTE = 1024.0;

    public MemUse(String marker) {
        this.heap = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        this.nonheap = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        this.marker = marker;
        this.date = new Date();
    }

    public String getMemUse() {
        System.gc();
        return this.getMemUse(null);
    }

    public String getMemUse(MemUse last) {
        StringBuilder sb = new StringBuilder();
        if (last != null) {
            sb.append(last.marker).append(": ").append(this.simple.format(last.date)).append(" - ");
        }
        sb.append(this.marker).append(": ");
        sb.append(this.simple.format(this.date)).append("\n");
        sb.append("Heap: ").append(this.heap.toString()).append("\n");
        sb.append("NonHeap: ").append(this.nonheap.toString()).append("\n");
        if (this.verbose) {
            List<MemoryPoolMXBean> beans = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : beans) {
                sb.append(memoryPoolMXBean.getName()).append(": ").append(memoryPoolMXBean.getUsage()).append("\n");
            }
            for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
                sb.append(garbageCollectorMXBean.getName()).append(": ").append(garbageCollectorMXBean.getCollectionCount()).append(": ").append(garbageCollectorMXBean.getCollectionTime()).append("\n");
            }
        }
        if (last != null) {
            long heapUse = this.heap.getUsed() - last.heap.getUsed();
            long l = this.nonheap.getUsed() - last.nonheap.getUsed();
            sb.append("total heap used: ").append(MemUse.toReadable(heapUse)).append("\n");
            sb.append("total non-heap used: ").append(MemUse.toReadable(l)).append("\n");
        }
        return sb.toString();
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public static final String toReadable(double bytes) {
        int suff = 0;
        while (bytes > 1024.0) {
            bytes /= 1024.0;
            ++suff;
        }
        return ("" + bytes + "   ").substring(0, 3) + suffix[suff];
    }
}

