/*
 * Decompiled with CFR 0.152.
 */
package rapture.common.exception;

import java.io.PrintWriter;
import java.io.StringWriter;
import rapture.common.Formattable;

public class ExceptionToString
implements Formattable {
    Throwable toss = null;

    public ExceptionToString(Throwable t) {
        this.toss = t;
    }

    public String toString() {
        return ExceptionToString.format(this.toss);
    }

    @Override
    public String format() {
        return this.toString();
    }

    public static void main(String[] args) {
        Throwable t = new Throwable("FOO", new Throwable("Bar", new Throwable("Baz")));
        System.out.println(ExceptionToString.format(t));
    }

    public static final String format(Throwable toss) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw){
            boolean stop = false;

            @Override
            public void print(String s) {
                if (s.startsWith("Caused by")) {
                    this.stop = true;
                } else if (!s.startsWith(" ") && !s.startsWith("\t")) {
                    this.stop = false;
                }
                if (!this.stop) {
                    super.print(s);
                }
            }

            @Override
            public void println() {
                if (!this.stop) {
                    super.println();
                }
            }
        };
        Throwable t = toss;
        while (t != null) {
            t.printStackTrace(pw);
            if ((t = t.getCause()) == null) continue;
            pw.append("Caused by: ");
        }
        return sw.toString();
    }
}

