/*
 * Decompiled with CFR 0.152.
 */
package rapture.common.impl.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import rapture.common.impl.jackson.ElementDeserializer;
import rapture.common.impl.jackson.ElementSerializer;
import rapture.common.impl.jackson.JsonContent;

public class MapperFactory {
    public static ObjectMapper createDefault() {
        ObjectMapper mapper = MapperFactory.create();
        String moduleName = "RaptureModule";
        SimpleModule myModule = MapperFactory.createModule(moduleName);
        mapper.registerModule((Module)myModule);
        return mapper;
    }

    public static SimpleModule createModule(String moduleName) {
        SimpleModule myModule = new SimpleModule(moduleName, new Version(1, 0, 0, "", null, null));
        myModule.addSerializer((JsonSerializer)new ElementSerializer(JsonContent.class, true));
        myModule.addDeserializer(JsonContent.class, (JsonDeserializer)new ElementDeserializer());
        return myModule;
    }

    public static ObjectMapper createForStorables() {
        return MapperFactory.create();
    }

    private static ObjectMapper create() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss"));
        mapper.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }
}

