/*
 * Decompiled with CFR 0.152.
 */
package rapture.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.log4j.Logger;
import rapture.common.exception.ExceptionToString;
import rapture.home.RaptureHomeRetriever;

public abstract class ConfigFileReader<T> {
    private static final Logger log = Logger.getLogger(ConfigFileReader.class);
    private String configFileName;
    private String globalConfigHome;
    private String appConfigHome;
    private String path;
    private String appName;
    private String globalConfigDir;
    private String dir;

    public ConfigFileReader(String configFileName) {
        this.configFileName = configFileName;
        this.globalConfigHome = RaptureHomeRetriever.getGlobalConfigHome();
        this.appConfigHome = RaptureHomeRetriever.getAppConfigHome();
        this.appName = RaptureHomeRetriever.getAppName();
    }

    public T findAndRead() {
        InputStream appConfigStream;
        InputStream globalConfigStream;
        T overlaidResult = null;
        InputStream defaultConfigStream = this.getStreamFromClasspath("defaults/");
        log.info((Object)this.foundMessage("default", "classpath", this.path));
        if (this.globalConfigHome != null) {
            log.info((Object)String.format("%s is set to %s, retrieve config from there for %s", "RAPTURE_CONFIG_HOME", this.globalConfigHome, this.configFileName));
            this.globalConfigDir = this.globalConfigHome;
            globalConfigStream = this.getStreamFromConfigHome(this.globalConfigHome);
            log.info((Object)this.foundMessage("global config", "RAPTURE_CONFIG_HOME", this.path));
            appConfigStream = this.getStreamFromConfigHome(this.appConfigHome);
            log.info((Object)this.foundMessage("app-specific config", "RAPTURE_CONFIG_HOME", this.path));
        } else {
            globalConfigStream = this.getStreamFromClasspath("");
            this.globalConfigDir = this.dir;
            log.info((Object)this.foundMessage("global config", "classpath", this.path));
            appConfigStream = this.getStreamFromClasspath(this.appName + "/");
            log.info((Object)this.foundMessage("app-specific config", "classpath", this.path));
        }
        File overlaidFile = null;
        try {
            overlaidFile = File.createTempFile(this.configFileName, ".cfg");
        }
        catch (IOException e) {
            log.warn((Object)("Error creating overlaid file: " + ExceptionToString.format(e)));
        }
        if (defaultConfigStream == null && globalConfigStream == null && appConfigStream == null) {
            log.warn((Object)("No config files found for " + this.configFileName));
        } else {
            overlaidResult = this.doOverlay(overlaidFile, defaultConfigStream, globalConfigStream, appConfigStream);
        }
        if (overlaidResult != null) {
            if (overlaidFile != null && overlaidFile.exists()) {
                log.debug((Object)("Overlaid file is available at " + overlaidFile.getAbsolutePath()));
            }
        } else {
            log.info((Object)("Unable to find overlay file for " + this.configFileName));
        }
        return overlaidResult;
    }

    private InputStream getStreamFromConfigHome(String configHome) {
        File file;
        this.path = null;
        this.dir = null;
        if (configHome != null && (file = new File(configHome, this.configFileName)).exists()) {
            try {
                FileInputStream stream = new FileInputStream(file);
                this.path = file.getAbsolutePath();
                return stream;
            }
            catch (FileNotFoundException e) {
                log.error((Object)("Error reading file: " + ExceptionToString.format(e)));
            }
        }
        return null;
    }

    private String foundMessage(String type, String where, String path) {
        if (path == null) {
            return String.format("No %s found for %s.", type, this.configFileName);
        }
        return String.format("Found %s for %s in %s. URL: %s", type, this.configFileName, where, path);
    }

    private InputStream getStreamFromClasspath(String dirName) {
        this.path = null;
        String defaultCfgPath = String.format("rapture/config/%s%s", dirName, this.configFileName);
        URL defaultURL = this.getClass().getClassLoader().getResource(defaultCfgPath);
        if (defaultURL != null) {
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(defaultCfgPath);
            this.path = defaultURL.toString();
            this.dir = new File(defaultURL.getFile()).getParent();
            return stream;
        }
        return null;
    }

    protected abstract T doOverlay(File var1, InputStream var2, InputStream ... var3);

    String getGlobalConfigDir() {
        return this.globalConfigDir;
    }
}

