/*
 * Decompiled with CFR 0.152.
 */
package rapture.config;

import org.apache.log4j.Logger;
import rapture.config.RaptureConfig;
import rapture.config.YamlConfigReader;

public class ConfigLoader {
    public static final String RAPTURE_CFG = "rapture.cfg";
    private static Logger log = Logger.getLogger(ConfigLoader.class);
    private static RaptureConfig conf;
    private static String globalConfigDir;

    static void loadYaml() {
        YamlConfigReader configFileReader;
        String configFileName = System.getProperty("RAPTURE_CONFIG_FILENAME");
        if (configFileName == null) {
            configFileName = RAPTURE_CFG;
        }
        if ((conf = (RaptureConfig)(configFileReader = new YamlConfigReader(configFileName)).findAndRead()) == null) {
            log.fatal((Object)"Unable to load rapture config from any sources.");
            conf = new RaptureConfig();
            conf.applyOverrides();
        } else {
            conf.applyOverrides();
            globalConfigDir = configFileReader.getGlobalConfigDir();
            log.info((Object)"Successfully loaded config file");
            if (!System.getProperty("os.arch").contains("64")) {
                log.info((Object)"32bit JVM detected.  It is recommended to run Rapture on a 64bit JVM for better performance.");
            }
        }
    }

    public static RaptureConfig getConf() {
        return conf;
    }

    public static String getGlobalConfigDir() {
        return globalConfigDir;
    }

    static {
        log.info((Object)"Loading Rapture Config");
        if (RaptureConfig.getLoadYaml()) {
            ConfigLoader.loadYaml();
        } else {
            conf = new RaptureConfig();
        }
    }
}

