/*
 * Decompiled with CFR 0.152.
 */
package rapture.config;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import rapture.common.exception.ExceptionToString;
import rapture.config.EnvironmentValueReader;
import rapture.config.JavaPropertiesConfigReader;
import rapture.config.SystemPropertyValueReader;
import rapture.config.ValueReader;
import rapture.home.RaptureHomeRetriever;

public enum MultiValueConfigLoader {
    INSTANCE;

    private static Logger log;
    private Map<String, Map<String, String>> knownAssignments = new HashMap<String, Map<String, String>>();
    private Map<String, String> knownGlobalDirs = new HashMap<String, String>();
    private Map<String, Boolean> isSeenBeforeMap = new HashMap<String, Boolean>();
    private ValueReader envReader = new EnvironmentValueReader();
    private ValueReader sysPropReader = new SystemPropertyValueReader();

    public static void setEnvReader(ValueReader reader) {
        MultiValueConfigLoader.INSTANCE.envReader = reader;
    }

    public static void setSysPropReader(ValueReader reader) {
        MultiValueConfigLoader.INSTANCE.sysPropReader = reader;
    }

    public static String getConfig(String configName, String defaultValue) {
        String retVal = MultiValueConfigLoader.getConfig(configName);
        if (retVal == null) {
            return defaultValue;
        }
        return retVal;
    }

    public static void writeConfig(String configName, String value) {
        log.debug((Object)("Storing config for " + configName));
        String[] parts = configName.split("-");
        String primary = parts[0];
        String secondary = "";
        if (parts.length > 1) {
            secondary = parts[1];
        }
        INSTANCE.saveUnderlyingConfig(primary, secondary, value);
    }

    public static String getConfig(String configName) {
        log.trace((Object)("Retrieving config for " + configName));
        String[] parts = configName.split("-");
        String primary = parts[0];
        String secondary = "";
        if (parts.length > 1) {
            secondary = parts[1];
        }
        return INSTANCE.getUnderlyingConfig(primary, secondary);
    }

    public static Set<String> getConfigKeys(String primary) {
        if (!MultiValueConfigLoader.INSTANCE.knownAssignments.containsKey(primary)) {
            INSTANCE.getUnderlyingConfig(primary, "");
        }
        if (MultiValueConfigLoader.INSTANCE.knownAssignments.containsKey(primary)) {
            return MultiValueConfigLoader.INSTANCE.knownAssignments.get(primary).keySet();
        }
        log.info((Object)("No config found for " + primary));
        return Collections.emptySet();
    }

    private void saveUnderlyingConfig(String primary, String secondary, String value) {
        this.removeFromKnownAssignments(primary, secondary);
        String configFileName = this.getConfigFileName(primary);
        String appConfigHome = RaptureHomeRetriever.getAppConfigHome();
        File configFile = null;
        if (appConfigHome != null) {
            configFile = new File(appConfigHome, configFileName);
        } else {
            String globalConfigHome = null;
            if (this.knownGlobalDirs.containsKey(configFileName)) {
                globalConfigHome = this.knownGlobalDirs.get(configFileName);
            } else {
                JavaPropertiesConfigReader configFileReader = new JavaPropertiesConfigReader(configFileName);
                configFileReader.findAndRead();
                globalConfigHome = configFileReader.getGlobalConfigDir();
                if (globalConfigHome != null) {
                    this.knownGlobalDirs.put(configFileName, globalConfigHome);
                }
            }
            if (globalConfigHome != null) {
                configFile = new File(globalConfigHome, configFileName);
            }
        }
        if (configFile != null) {
            if (configFile.isAbsolute()) {
                log.info((Object)String.format("About to save config for %s-%s into file %s", primary, secondary, configFile.getAbsolutePath()));
                this.saveToFile(configFile, secondary, value, true);
            } else {
                log.info((Object)String.format("Will not store config, not an absolute path: %s", configFile.getAbsolutePath()));
            }
        } else {
            log.error((Object)String.format("App config and global config home not set, saving config not supported for for %s-%s ", primary, secondary));
        }
        this.saveReturn(primary, secondary, value);
    }

    private boolean saveToFile(File file, String propertyName, String propertyValue, boolean createIfNotExist) {
        try {
            String line;
            if (!file.exists()) {
                if (!createIfNotExist) {
                    return false;
                }
                file.createNewFile();
            }
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder newFile = new StringBuilder();
            boolean changed = false;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#") || line.isEmpty() || line.startsWith("[")) {
                    newFile.append(line);
                } else {
                    int indexPoint = line.indexOf(61);
                    String left = line.substring(0, indexPoint);
                    if (left.equals(propertyName)) {
                        newFile.append(left);
                        newFile.append("=");
                        newFile.append(propertyValue);
                        changed = true;
                    } else {
                        newFile.append(line);
                    }
                }
                newFile.append("\n");
            }
            reader.close();
            if (!changed) {
                newFile.append(propertyName);
                newFile.append("=");
                newFile.append(propertyValue);
                newFile.append("\n");
            }
            FileOutputStream newOutput = new FileOutputStream(file, false);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(newOutput));
            writer.append(newFile.toString());
            writer.close();
        }
        catch (IOException e) {
            log.error((Object)("Problem when saving value in config file: " + ExceptionToString.format(e)));
        }
        return false;
    }

    private String getUnderlyingConfig(String primary, String secondary) {
        String potentialReturn = this.getFromKnownAssignments(primary, secondary);
        if (potentialReturn != null) {
            return potentialReturn;
        }
        String foundString = String.format("Found %s-%s in ", primary, secondary);
        log.trace((Object)("Not currently known, looking for " + primary + " - " + secondary));
        potentialReturn = this.getFromSystemProperty(primary, secondary);
        if (potentialReturn != null) {
            log.info((Object)(foundString + " defined property"));
            return this.saveReturn(primary, secondary, potentialReturn);
        }
        potentialReturn = this.getFromEnvironment(primary, secondary);
        if (potentialReturn != null) {
            log.info((Object)(foundString + " environment"));
            return this.saveReturn(primary, secondary, potentialReturn);
        }
        if (!this.isReadFromFile(primary)) {
            String configFileName = this.getConfigFileName(primary);
            JavaPropertiesConfigReader configFileReader = new JavaPropertiesConfigReader(configFileName);
            Map map = (Map)configFileReader.findAndRead();
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    this.saveReturn(primary, entry.getKey().toString(), entry.getValue().toString());
                }
                this.knownGlobalDirs.put(configFileName, configFileReader.getGlobalConfigDir());
            }
            this.setReadFromFile(primary);
        }
        return this.getFromKnownAssignments(primary, secondary);
    }

    private void setReadFromFile(String primary) {
        this.isSeenBeforeMap.put(primary, true);
    }

    private boolean isReadFromFile(String primary) {
        return this.isSeenBeforeMap.containsKey(primary);
    }

    private String getConfigFileName(String primary) {
        return "Rapture" + primary.toUpperCase() + ".cfg";
    }

    private void removeFromKnownAssignments(String primary, String secondary) {
        if (this.knownAssignments.containsKey(primary)) {
            this.knownAssignments.get(primary).remove(secondary);
        }
    }

    private String getFromKnownAssignments(String primary, String secondary) {
        if (this.knownAssignments.containsKey(primary) && this.knownAssignments.get(primary).containsKey(secondary)) {
            return this.knownAssignments.get(primary).get(secondary);
        }
        return null;
    }

    private String getFromEnvironment(String primary, String secondary) {
        String checkName = this.getStandardName(primary, secondary);
        log.trace((Object)("Looking for " + checkName + " through env reader"));
        return this.envReader.getValue(checkName);
    }

    private String saveReturn(String primary, String secondary, String potentialReturn) {
        if (!this.knownAssignments.containsKey(primary)) {
            this.knownAssignments.put(primary, new HashMap());
        }
        this.knownAssignments.get(primary).put(secondary, potentialReturn);
        return potentialReturn;
    }

    private String getFromSystemProperty(String primary, String secondary) {
        String checkProperty = this.getStandardName(primary, secondary);
        log.trace((Object)("Looking for " + checkProperty + " through property reader"));
        return this.sysPropReader.getValue(checkProperty);
    }

    private String getStandardName(String primary, String secondary) {
        return primary.toUpperCase() + "-" + secondary.toUpperCase();
    }

    static {
        log = Logger.getLogger(MultiValueConfigLoader.class);
    }
}

