/*
 * Decompiled with CFR 0.152.
 */
package rapture.config;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Paths;
import org.apache.log4j.Logger;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.config.FolderCleanupConfig;
import rapture.config.WebConfig;
import rapture.util.ConfigRetriever;

public class RaptureConfig {
    private static boolean loadYaml = true;
    private static Logger log = Logger.getLogger(RaptureConfig.class);
    public String KernelUser = "raptureApi";
    public String CacheExpiry = "";
    public String RaptureRepo = "REP {} USING MEMORY {}";
    public String ServerType = "webserver";
    public String StandardTemplate = "REP {} USING MEMORY {}";
    public String DefaultAudit = "LOG {} USING MEMORY {}";
    public String DefaultExchange = "EXCHANGE {} USING MEMORY {}";
    public String DefaultCommentary = "COMMENTARY {} USING MEMORY {}";
    public String DefaultNotification = "NOTIFICATION USING MEMORY {}";
    public String DefaultStatus = "STATUS {} USING MEMORY {}";
    public String DefaultPipelineTaskStatus = "INDEX {} USING MEMORY {}";
    public String Categories = "alpha";
    public Boolean WorkflowOnPipeline = false;
    public Boolean InitConfig = false;
    public String InitSysConfig = "NREP {} USING MEMORY { prefix=\"sys.config\"}";
    public String InitSysEphemeral = "REP {} USING MEMORY { prefix=\"sys.emphemeral\"}";
    public String InitSysSettings = "NREP {} USING MEMORY { prefix=\"sys.settings\"}";
    public String DefaultDecisionRepoConfig = "NREP {} USING MEMORY { prefix=\"sys.decision\"}";
    public String DefaultDecisionIdGenConfig = "IDGEN { base=\"36\", length=\"8\", prefix=\"wo.\" } USING MEMORY {}";
    public String EventIdGenConfig = "IDGEN { base=\"36\", length=\"8\", prefix=\"mem-event.\" } USING MEMORY {}";
    public String ActivityIdGenConfig = "IDGEN { base=\"36\", length=\"8\", prefix=\"\" } USING MEMORY {}";
    public String DefaultSemaphoreConfig = "LOCKING USING MEMORY {}";
    public String DefaultKernelLockConfig = "LOCKING USING MEMORY {}";
    public String DefaultWorkflowLockConfig = "LOCKING USING MEMORY {}";
    public String DefaultSystemBlobConfig = "BLOB {} USING MEMORY {}";
    public String DefaultSystemBlobFoldersConfig = "REP {} USING MEMORY {}";
    public String DefaultJarRepoConfig = "BLOB {} USING MEMORY {}";
    public String DefaultJarRepoMetaConfig = "REP {} USING MEMORY {}";
    public String DefaultWorkflowAuditLog = "LOG {} USING NOTHING { blobRepo = \"sys.blob\"}";
    public String DefaultPerfAuditLog = "LOG {} USING NOTHING { blobRepo = \"sys.blob\"}";
    public Boolean SystemBlobConfigOn = true;
    public String ServerGroup = "localRun";
    public String AppInstance = "localRun";
    public String AppName = "unknown";
    public String DefaultApiHooks = "{\"idToHook\":{\"AuditHook\":{\"id\":\"AuditHook\",\"className\":\"rapture.api.hooks.impl.AuditApiHook\",\"hookTypes\":[\"PRE\"]}}}";
    public String IsOverlaid = "false";
    public Boolean RelationshipSystemActive = false;
    public Boolean AllowAutoRepoCreation = true;
    public Boolean PerformanceSystemActive = false;
    public String FileRepoDirectory = "";
    public String JarStorage = "FILE";
    public String DefaultPythonLocation = "/usr/bin/python";
    public String DefaultAnacondaPythonLocation = "/opt/anaconda/bin/python";
    public String DefaultAnacondaRoot = "/opt/anaconda/envs/";
    public FolderCleanupConfig folderCleanup = new FolderCleanupConfig();
    public WebConfig web = new WebConfig();
    public WebConfig execWeb = new WebConfig("8667");
    public Boolean Configured = false;
    public Boolean randomizeDefaultPasswords = false;
    public Boolean FullTextSearchOn = false;
    public String FullTextSearchDefaultRepo = "search://main";
    public String FullTextSearchDefaultConfig = "SEARCH {} USING ELASTIC { index = \"rapturemain\" }";

    public static boolean getLoadYaml() {
        return loadYaml;
    }

    public static void setLoadYaml(boolean load) {
        loadYaml = load;
    }

    public void applyOverrides() {
        for (Field f : RaptureConfig.class.getDeclaredFields()) {
            String attrName;
            String val;
            if (!Modifier.isPublic(f.getModifiers()) || (val = ConfigRetriever.getSetting(null, attrName = "RAPTURE_" + f.getName().toUpperCase(), null)) == null) continue;
            log.info((Object)("Overriding " + f.getName() + " to " + val));
            if (f.getType().equals(String.class)) {
                try {
                    f.set(this, val);
                    continue;
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    throw RaptureExceptionFactory.create((Integer)500, "Error reading config", (Throwable)e);
                }
            }
            if (!f.getType().equals(Boolean.class)) continue;
            try {
                f.set(this, Boolean.valueOf(val));
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw RaptureExceptionFactory.create((Integer)500, "Error reading config", (Throwable)e);
            }
        }
        this.ensureValidFileRepoDirectory();
    }

    private void ensureValidFileRepoDirectory() {
        String baseDir = this.FileRepoDirectory;
        String userHome = System.getProperty("user.home").replace('\\', '/');
        if (baseDir.contains("\\")) {
            throw RaptureExceptionFactory.create("FileRepoDirectory cannot contain backslashes (\\). Please replace with slashes (/).");
        }
        if (baseDir == null || baseDir.isEmpty()) {
            baseDir = userHome + "/RaptureFileRepositories/";
        } else {
            if (baseDir.startsWith("~")) {
                if (baseDir.startsWith("~/")) {
                    baseDir = baseDir.replaceFirst("^~", userHome);
                } else {
                    throw RaptureExceptionFactory.create("Cannot expand ~ for other users in FileRepoDirectory configuration.");
                }
            }
            if (!Paths.get(baseDir, new String[0]).isAbsolute()) {
                throw RaptureExceptionFactory.create("Please specify an absolute path for FileRepoDirectory configuration.");
            }
            if (!baseDir.endsWith("/")) {
                baseDir = baseDir + "/";
            }
        }
        if (baseDir != this.FileRepoDirectory) {
            log.info((Object)("Overriding FileRepoDirectory from " + this.FileRepoDirectory + " to " + baseDir));
            this.FileRepoDirectory = baseDir;
        }
    }
}

