/*
 * Decompiled with CFR 0.152.
 */
package rapture.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import rapture.common.exception.ExceptionToString;
import rapture.config.ConfigFileReader;
import rapture.config.RaptureConfig;

public class YamlConfigReader
extends ConfigFileReader<RaptureConfig> {
    private static final Logger log = Logger.getLogger(YamlConfigReader.class);

    public YamlConfigReader(String configFileName) {
        super(configFileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    protected RaptureConfig doOverlay(File overlaidFile, InputStream originalStream, InputStream ... overridesStreams) {
        try {
            String currentString = null;
            if (originalStream != null) {
                try {
                    List lines = IOUtils.readLines((InputStream)originalStream);
                    currentString = StringUtils.join((Iterable)lines, (String)"\n");
                }
                catch (IOException e) {
                    log.error((Object)("Error reading original stream: " + ExceptionToString.format(e)));
                }
            }
            for (InputStream overridesStream : overridesStreams) {
                String overridesString = null;
                if (overridesStream != null) {
                    try {
                        List lines = IOUtils.readLines((InputStream)overridesStream);
                        overridesString = StringUtils.join((Iterable)lines, (String)"\n");
                    }
                    catch (IOException e) {
                        log.error((Object)("Error reading original stream: " + ExceptionToString.format(e)));
                    }
                }
                currentString = YamlConfigReader.overlayYaml(currentString, overridesString);
            }
            try {
                FileUtils.write((File)overlaidFile, (CharSequence)currentString);
            }
            catch (IOException e1) {
                log.error((Object)String.format("Error writing to overlay file: %s", ExceptionToString.format(e1)));
            }
            Constructor constructor = new Constructor(RaptureConfig.class);
            try {
                Yaml yaml = new Yaml((BaseConstructor)constructor);
                RaptureConfig raptureConfig = (RaptureConfig)yaml.load(currentString);
                return raptureConfig;
            }
            catch (RuntimeException e) {
                RaptureConfig raptureConfig;
                block30: {
                    log.fatal((Object)("Error overlaying yaml: " + ExceptionToString.format(e)));
                    raptureConfig = null;
                    if (originalStream == null) break block30;
                    try {
                        originalStream.close();
                    }
                    catch (IOException e2) {
                        log.warn((Object)("Error closing stream\n" + ExceptionToString.format(e2)));
                    }
                }
                for (InputStream overridesStream : overridesStreams) {
                    if (overridesStream == null) continue;
                    try {
                        overridesStream.close();
                    }
                    catch (IOException e3) {
                        log.warn((Object)("Error closing stream\n" + ExceptionToString.format(e3)));
                    }
                }
                return raptureConfig;
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            if (originalStream != null) {
                try {
                    originalStream.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error closing stream\n" + ExceptionToString.format(e)));
                }
            }
            for (InputStream overridesStream : overridesStreams) {
                if (overridesStream == null) continue;
                try {
                    overridesStream.close();
                }
                catch (IOException e) {
                    log.warn((Object)("Error closing stream\n" + ExceptionToString.format(e)));
                }
            }
        }
    }

    public static String overlayYaml(String originalYaml, String overridesYaml) {
        Map overrides;
        if (overridesYaml == null) {
            return originalYaml;
        }
        Yaml yaml = new Yaml();
        Map overlaid = originalYaml != null ? (Map)yaml.loadAs(originalYaml, Map.class) : new HashMap();
        if (overridesYaml.length() > 0) {
            try {
                overrides = (Map)yaml.loadAs(overridesYaml, Map.class);
            }
            catch (YAMLException e) {
                log.error((Object)String.format("Error decoding YAML:\n%s\n", ExceptionToString.format(e)));
                overrides = new HashMap();
            }
        } else {
            overrides = new HashMap();
        }
        if (overrides != null) {
            for (Map.Entry entry : overrides.entrySet()) {
                overlaid.put(entry.getKey(), entry.getValue());
            }
        }
        return yaml.dump(overlaid);
    }
}

