/*
 * Decompiled with CFR 0.152.
 */
package rapture.home;

import java.io.File;

public enum RaptureHomeRetriever {
    INSTANCE;

    private String globalConfigHome;
    private String home = this.getPropOrEnv("RAPTURE_HOME");
    private String appConfigHome;
    private String appName;
    public static final String GLOBAL_CONFIG_HOME = "RAPTURE_CONFIG_HOME";
    public static final String APP_NAME = "RAPTURE_APP_NAME";
    public static final String RAPTURE_HOME = "RAPTURE_HOME";

    private RaptureHomeRetriever() {
        this.globalConfigHome = this.getPropOrEnv(GLOBAL_CONFIG_HOME);
        this.appName = this.getPropOrEnv(APP_NAME);
        this.appConfigHome = this.appName != null && this.globalConfigHome != null ? this.globalConfigHome + File.separator + this.appName : null;
    }

    private String getPropOrEnv(String key) {
        String value = System.getProperty(key);
        if (value == null) {
            value = System.getenv(key);
        }
        return value;
    }

    public static String getRaptureHome() {
        return RaptureHomeRetriever.INSTANCE.home;
    }

    public static String getGlobalConfigHome() {
        return RaptureHomeRetriever.INSTANCE.globalConfigHome;
    }

    public static String getAppConfigHome() {
        return RaptureHomeRetriever.INSTANCE.appConfigHome;
    }

    public static String getAppName() {
        return RaptureHomeRetriever.INSTANCE.appName;
    }
}

