/*
 * Decompiled with CFR 0.152.
 */
package rapture.parser;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import org.antlr.runtime.ANTLRStringStream;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import rapture.generated.CSVLexer;
import rapture.generated.CSVParser;
import rapture.parser.CSVCallback;
import rapture.parser.FileStreamer;
import rapture.parser.StandardCallback;

public class CSVExtractor {
    public static List<List<String>> getCSV(String content) throws RecognitionException {
        StandardCallback callback = new StandardCallback();
        CSVExtractor.getCSV(content, callback);
        return callback.getOutput();
    }

    public static void getCSV(String content, CSVCallback callback) throws RecognitionException {
        CSVLexer lexer = new CSVLexer();
        lexer.setCharStream((CharStream)new ANTLRStringStream(content));
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        CSVParser parser = new CSVParser((TokenStream)tokens);
        parser.setCallback(callback);
        parser.file();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamCSV(String fileName, CSVCallback callback) throws FileNotFoundException, RecognitionException {
        try (FileStreamer fs = null;){
            fs = FileStreamer.lines(fileName);
            for (String line : fs) {
                CSVExtractor.getCSV(line, callback);
            }
        }
    }

    public static void streamCSV(InputStream stream, CSVCallback callback) throws IOException, RecognitionException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        while ((line = reader.readLine()) != null) {
            CSVExtractor.getCSV(line, callback);
        }
    }
}

