/*
 * Decompiled with CFR 0.152.
 */
package rapture.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.log4j.Logger;

public class NetworkUtil {
    private static final Logger log = Logger.getLogger(NetworkUtil.class);

    private NetworkUtil() {
    }

    public static String getServerIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            log.error((Object)"Unable to get the IP address of this machine", (Throwable)e);
            return null;
        }
    }

    public static String getSiteLocalServerIP() {
        Enumeration<NetworkInterface> nics;
        try {
            nics = NetworkInterface.getNetworkInterfaces();
        }
        catch (SocketException e) {
            log.error((Object)"Unable to access network interfaces on this machine", (Throwable)e);
            return null;
        }
        while (nics.hasMoreElements()) {
            NetworkInterface nic = nics.nextElement();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Processing nic: " + nic.getName() + ":" + nic.getDisplayName()));
            }
            Enumeration<InetAddress> addrs = nic.getInetAddresses();
            while (addrs.hasMoreElements()) {
                InetAddress addr = addrs.nextElement();
                log.debug((Object)("IP addr is: " + addr.getHostAddress()));
                if (!addr.isSiteLocalAddress()) continue;
                return addr.getHostAddress();
            }
        }
        return null;
    }

    public static String getServerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            log.error((Object)"Unable to get hostname of this machine", (Throwable)e);
            return null;
        }
    }
}

