/*
 * Decompiled with CFR 0.152.
 */
package rapture.util;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import rapture.util.encode.RaptureEncodeFilter;
import rapture.util.encode.RaptureEncodeHelper;
import rapture.util.encode.RaptureURLCoderFilter;

public class RaptureURLCoder
extends RaptureEncodeHelper {
    private static final RaptureEncodeFilter FILTER = new RaptureURLCoderFilter();

    public static String encode(String value) {
        return RaptureURLCoder.encode(value, FILTER);
    }

    public static String encode(String value, RaptureEncodeFilter filter) {
        StringBuilder ret = new StringBuilder();
        int cpc = value.codePointCount(0, value.length());
        for (int i = 0; i < cpc; ++i) {
            int codePoint = value.codePointAt(i);
            if (codePoint == 37 || filter.isNeedsEncode(codePoint)) {
                if (codePoint == 32) {
                    ret.append("%20");
                    continue;
                }
                try {
                    ret.append(URLEncoder.encode(new String(Character.toChars(codePoint)), "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    ret.append(Character.toChars(codePoint));
                }
                continue;
            }
            ret.append(Character.toChars(codePoint));
        }
        String retval = ret.toString();
        return retval;
    }
}

