/*
 * Decompiled with CFR 0.152.
 */
package rapture.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import rapture.common.exception.RaptureExceptionFactory;

public class ResourceLoader {
    public static String getResourceAsString(Object context, String path) {
        InputStream is = (context == null ? ResourceLoader.class : context.getClass()).getResourceAsStream(path);
        return ResourceLoader.getResourceFromInputStream(is);
    }

    public static String getResourceFromInputStream(InputStream is) {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try {
                int n;
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            catch (IOException e) {
                throw RaptureExceptionFactory.create((Integer)500, "Error reading resource stream", (Throwable)e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException e) {
                    throw RaptureExceptionFactory.create((Integer)500, "Error closing stream", (Throwable)e);
                }
            }
            return ((Object)writer).toString();
        }
        return "";
    }

    public static List<String> getScripts(Object context, String resourcePath) {
        if (resourcePath == null || resourcePath.equals("")) {
            return null;
        }
        URL resourceURL = (context == null ? ResourceLoader.class : context.getClass()).getResource(resourcePath);
        if (resourceURL == null) {
            return null;
        }
        ArrayList<String> retVal = new ArrayList<String>();
        if (resourceURL.getProtocol().equals("jar")) {
            ResourceLoader.loadFromJar(resourcePath, resourceURL, retVal);
        } else {
            ResourceLoader.loadFromURL(resourceURL, retVal);
        }
        return retVal;
    }

    private static void loadFromURL(URL resourceURL, List<String> retVal) {
        InputStreamReader isr = null;
        BufferedReader reader = null;
        try {
            isr = new InputStreamReader(resourceURL.openStream());
            reader = new BufferedReader(isr);
            while (reader.ready()) {
                String val = reader.readLine();
                retVal.add(val);
            }
        }
        catch (IOException e) {
            throw RaptureExceptionFactory.create((Integer)500, "Error reading resource from URI", (Throwable)e);
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException iOException) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadFromJar(String resourcePath, URL resourceURL, List<String> retVal) {
        JarFile jf;
        int bangLoc = resourceURL.getPath().lastIndexOf(33);
        String uriString = resourceURL.getPath().substring(0, bangLoc);
        try {
            URI uri = new URI(uriString);
            jf = new JarFile(new File(uri));
        }
        catch (URISyntaxException e) {
            throw RaptureExceptionFactory.create((Integer)500, "Error reading URI", (Throwable)e);
        }
        catch (IOException e) {
            throw RaptureExceptionFactory.create((Integer)500, "Error reading from URI", (Throwable)e);
        }
        try {
            Enumeration<JarEntry> jarEntries = jf.entries();
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1);
            }
            while (jarEntries.hasMoreElements()) {
                JarEntry entry = jarEntries.nextElement();
                if (!entry.getName().matches(resourcePath + ".+")) continue;
                String name = entry.getName().replaceFirst(resourcePath, "");
                retVal.add(name);
            }
        }
        finally {
            try {
                jf.close();
            }
            catch (IOException iOException) {}
        }
    }
}

