/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import rapture.common.CallingContext;
import rapture.common.ErrorWrapper;
import rapture.common.exception.ExceptionToString;
import rapture.common.exception.RaptNotLoggedInException;
import rapture.common.exception.RaptureException;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.common.impl.jackson.JacksonUtil;
import rapture.kernel.script.KernelScript;
import rapture.server.BaseDispatcher;
import rapture.server.web.servlet.BaseServlet;
import rapture.server.web.servlet.ReflexScriptPageHandler;
import reflex.IReflexHandler;
import reflex.ReflexException;
import reflex.ReflexExecutor;

public abstract class BaseReflexScriptPageServlet
extends BaseServlet {
    private static final long serialVersionUID = 2930792109818985861L;
    private static final Logger logger = Logger.getLogger(BaseReflexScriptPageServlet.class);

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug((Object)("req is " + req));
        logger.debug((Object)("resp is " + resp));
        logger.debug((Object)("request variables " + this.getRequestVariables(req)));
        String script = this.getReflexScript(req);
        if (script == null || script.isEmpty()) {
            resp.setStatus(404);
            return;
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        HashMap<String, HashMap<String, String[]>> paramSet = new HashMap<String, HashMap<String, String[]>>();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            Object arg;
            String key = (String)e.nextElement();
            String[] val = req.getParameterValues(key);
            if (key.endsWith("[]")) {
                arg = val;
                key = key.substring(0, key.length() - 2);
            } else {
                arg = val[0];
            }
            parameterMap.put(key, arg);
            int idx = key.lastIndexOf("[");
            while (idx > 0) {
                String v = key.substring(idx + 1, key.length() - 1);
                String k = key.substring(0, idx);
                HashMap<String, String[]> map = (HashMap<String, String[]>)paramSet.get(k);
                if (map == null) {
                    map = new HashMap<String, String[]>();
                    paramSet.put(k, map);
                }
                map.put(v, (String[])arg);
                arg = map;
                parameterMap.put(k, map);
                key = k;
                idx = key.lastIndexOf("[");
            }
        }
        this.process(script, parameterMap, req, resp);
    }

    protected abstract String getPrintableScript(HttpServletRequest var1);

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        logger.debug((Object)("req is " + req));
        logger.debug((Object)("resp is " + resp));
        logger.debug((Object)("request variables " + this.getRequestVariables(req)));
        String script = this.getReflexScript(req);
        if (script == null || script.isEmpty()) {
            resp.setStatus(404);
            return;
        }
        Map<String, Object> props = this.getParams(req);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        for (String key : props.keySet()) {
            Object val = props.get(key);
            if (val instanceof String) {
                val = URLDecoder.decode((String)val, "UTF-8");
            }
            parameterMap.put(key, val);
        }
        this.process(script, parameterMap, req, resp);
    }

    protected abstract String getReflexScript(HttpServletRequest var1);

    void process(String script, Map<String, Object> parameterMap, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug((Object)("script is " + script));
        logger.debug((Object)("parameterMap is " + parameterMap));
        HashMap<String, Map<String, Object>> masterParameterMap = new HashMap<String, Map<String, Object>>();
        masterParameterMap.put("web", parameterMap);
        masterParameterMap.put("SERVER", this.getRequestVariables(req));
        ReflexScriptPageHandler handler = new ReflexScriptPageHandler();
        KernelScript kScript = new KernelScript();
        try {
            CallingContext context = BaseDispatcher.validateSession((HttpServletRequest)req);
            if (context != null) {
                logger.trace((Object)("Got session context " + context.debug()));
                kScript.setCallingContext(context);
                handler.setScriptApi(kScript);
                ReflexExecutor.runReflexProgram((String)script, (IReflexHandler)handler, masterParameterMap);
                resp.setCharacterEncoding("UTF-8");
                resp.getWriter().append(handler.getOutput());
                resp.setContentType("text/plain");
            } else {
                String err = "Cannot execute script " + script + " : cannot get session context for authorization";
                logger.error((Object)err);
                resp.sendError(401, err);
            }
        }
        catch (RaptNotLoggedInException re) {
            logger.error((Object)("Cannot execute script " + script + " : " + re.getMessage()));
            resp.sendError(re.getStatus().intValue(), re.getMessage());
        }
        catch (ReflexException re) {
            logger.debug((Object)ExceptionToString.format((Throwable)re));
            Throwable cause = re.getCause();
            if (cause == null) {
                cause = re;
            }
            while (cause.getCause() != null && !(cause instanceof RaptureException)) {
                cause = cause.getCause();
            }
            RaptureException rapEx = cause instanceof RaptureException ? (RaptureException)cause : (re.getMessage() != null ? RaptureExceptionFactory.create((String)("Error calling Reflex script: " + re.getMessage()), (Throwable)re) : RaptureExceptionFactory.create((String)"Error calling Reflex script", (Throwable)re));
            logger.error((Object)("Cannot execute script " + this.getPrintableScript(req) + " : " + rapEx.getFormattedMessage()));
            ErrorWrapper ew = new ErrorWrapper();
            ew.setStatus(rapEx.getStatus());
            ew.setMessage(rapEx.getMessage());
            ew.setId(rapEx.getId());
            ew.setStackTrace(ExceptionUtils.getFullStackTrace((Throwable)re));
            this.sendVerboseError(resp, ew);
        }
        resp.flushBuffer();
    }

    private void sendVerboseError(HttpServletResponse resp, ErrorWrapper ew) throws IOException {
        Map map = JacksonUtil.getHashFromObject((Object)ew);
        map.put("error", ew.getMessage());
        String r = JacksonUtil.jsonFromObject((Object)map);
        resp.setStatus(500);
        resp.setCharacterEncoding("UTF-8");
        resp.getWriter().append(r);
        resp.setContentType("text/plain");
    }

    private Map<String, Object> getRequestVariables(HttpServletRequest req) {
        HashMap<String, Object> serverMap = new HashMap<String, Object>();
        serverMap.put("ContentType", req.getContentType());
        serverMap.put("ContextPath", req.getContextPath());
        serverMap.put("Method", req.getMethod());
        serverMap.put("PathInfo", req.getPathInfo());
        serverMap.put("RemoteAddr", req.getRemoteAddr());
        serverMap.put("", req.getLocalAddr());
        serverMap.put("Headers", this.getHeaderVariables(req));
        serverMap.put("Attributes", this.getHeaderAttributes(req));
        return serverMap;
    }

    private Map<String, Object> getHeaderVariables(HttpServletRequest req) {
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headerMap.put(headerName, req.getHeader(headerName));
        }
        return headerMap;
    }

    private Map<String, Object> getHeaderAttributes(HttpServletRequest req) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Enumeration vars = req.getAttributeNames();
        while (vars.hasMoreElements()) {
            String attrName = (String)vars.nextElement();
            variables.put(attrName, req.getAttribute(attrName));
        }
        return variables;
    }
}

