/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import external.multipart.BufferedServletInputStream;
import external.multipart.MultipartParser;
import external.multipart.ParamGetter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.apache.log4j.Logger;
import rapture.common.CallingContext;
import rapture.common.DispatchReturn;
import rapture.common.IEntitlementsContext;
import rapture.common.RaptureEntitlementsContext;
import rapture.common.exception.ExceptionToString;
import rapture.common.exception.RaptureException;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.common.impl.jackson.JacksonUtil;
import rapture.kernel.Kernel;
import rapture.server.BaseDispatcher;
import rapture.server.web.servlet.StandardCallInfo;

@MultipartConfig
public class BaseServlet
extends HttpServlet {
    private static final long serialVersionUID = 488948490778665765L;
    private static final int MAXPARAMSIZE = 600000;
    private static Logger log = Logger.getLogger(BaseServlet.class);
    private static final String DEFAULT_ENCODING = "UTF-8";
    private String encoding = "UTF-8";
    private byte[] buf = new byte[8192];

    protected CallingContext getSessionContext(HttpServletRequest req) {
        log.info((Object)"Retrieving context from session");
        HttpSession session = req.getSession(false);
        if (session == null) {
            log.info((Object)"No login context");
            return null;
        }
        log.debug((Object)"Returning session login context");
        return (CallingContext)session.getAttribute("context");
    }

    protected String getFullContent(HttpServletRequest req) throws IOException {
        String line;
        ServletInputStream in = req.getInputStream();
        in = new BufferedServletInputStream(in);
        StringBuilder ret = new StringBuilder();
        while ((line = this.readLine(in)) != null) {
            ret.append(line);
        }
        return ret.toString();
    }

    protected Map<String, Object> getParams(HttpServletRequest req) throws UnsupportedEncodingException, IOException, ServletException {
        String contentType = req.getContentType();
        Collection parts = null;
        try {
            parts = req.getParts();
        }
        catch (Exception e) {
            log.debug((Object)("Error parsing request parts " + e.getMessage()));
        }
        if (parts != null && !parts.isEmpty()) {
            HashMap<String, Object> props = new HashMap<String, Object>();
            for (Part p : parts) {
                String realContent = this.getContentFromPart(p);
                props.put(p.getName(), realContent);
            }
            return props;
        }
        Map props = null;
        if (contentType.indexOf("application/x-www-form-urlencoded") >= 0) {
            String result = URLDecoder.decode(this.getFullContent(req), this.encoding);
            props = ParamGetter.getProps((String)result);
        } else if (contentType.indexOf("multipart/form-data") >= 0) {
            MultipartParser parser = new MultipartParser(req, 600000);
            props = ParamGetter.getProps((MultipartParser)parser);
        } else if (contentType.indexOf("application/json") >= 0) {
            props = JacksonUtil.getMapFromJson((InputStream)req.getInputStream());
        } else {
            log.error((Object)("Cannot parse contentType of " + contentType));
            throw new IOException("Bad content type of " + contentType);
        }
        return props;
    }

    private String getStringFromInputStream(InputStream is) throws IOException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        byte[] buffer = new byte[10240];
        int length = 0;
        while ((length = is.read(buffer)) > 0) {
            bao.write(buffer, 0, length);
        }
        bao.close();
        return new String(bao.toByteArray());
    }

    protected byte[] getByteContentFromPart(Part p) throws IOException {
        InputStream inputStream = p.getInputStream();
        ByteArrayOutputStream bai = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        boolean done = false;
        while (!done) {
            int count = inputStream.read(buffer);
            if (count <= 0) {
                done = true;
                continue;
            }
            bai.write(buffer, 0, count);
        }
        bai.close();
        inputStream.close();
        byte[] ret = bai.toByteArray();
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getContentFromPart(Part p) {
        String contentType = p.getContentType();
        InputStream inputStream = null;
        try {
            if (contentType == null || contentType.startsWith("text/plain")) {
                inputStream = p.getInputStream();
            } else if (contentType.equals("application/octet-stream")) {
                inputStream = new GZIPInputStream(p.getInputStream());
            } else {
                log.error((Object)String.format("Unknown content type %s", contentType));
                String string = null;
                return string;
            }
            String string = this.getStringFromInputStream(inputStream);
            return string;
        }
        catch (IOException e) {
            log.error((Object)("Could not parse input " + ExceptionToString.format((Throwable)e)));
            String string = null;
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    log.error((Object)("Error closing input stream " + ExceptionToString.format((Throwable)e)));
                }
            }
        }
    }

    protected StandardCallInfo processFunctionalRequest(HttpServletRequest req) throws UnsupportedEncodingException, IOException, ServletException {
        StandardCallInfo ret = new StandardCallInfo();
        Map<String, Object> props = this.getParams(req);
        ret.setFunctionName((String)props.get("FUNCTION"));
        ret.setContent((String)props.get("PARAMS"));
        log.debug((Object)("Function is " + ret.getFunctionName()));
        return ret;
    }

    private String readLine(ServletInputStream in) throws IOException {
        int result;
        StringBuilder sbuf = new StringBuilder();
        do {
            if ((result = in.readLine(this.buf, 0, this.buf.length)) == -1) continue;
            sbuf.append(new String(this.buf, 0, result, this.encoding));
        } while (result == this.buf.length);
        if (sbuf.length() == 0) {
            return null;
        }
        int len = sbuf.length();
        if (len >= 2 && sbuf.charAt(len - 2) == '\r') {
            sbuf.setLength(len - 2);
        } else if (len >= 1 && sbuf.charAt(len - 1) == '\n') {
            sbuf.setLength(len - 1);
        }
        return sbuf.toString();
    }

    protected void validateContext(CallingContext context, String entPath, RaptureEntitlementsContext entCtx) {
        Kernel.getKernel().validateContext(context, entPath, (IEntitlementsContext)entCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendResponseAppropriately(CallingContext context, HttpServletRequest req, HttpServletResponse resp, String response) throws IOException {
        String encoding = req.getHeader("Accept-Encoding");
        resp.setContentType("application/json");
        if (encoding != null && encoding.indexOf("gzip") >= 0) {
            resp.setHeader("Content-Encoding", "gzip");
            ServletOutputStream o = null;
            DeflaterOutputStream gz = null;
            try {
                o = resp.getOutputStream();
                gz = new GZIPOutputStream((OutputStream)o);
                gz.write(response.getBytes(DEFAULT_ENCODING));
            }
            finally {
                if (gz != null) {
                    gz.close();
                }
                if (o != null) {
                    o.close();
                }
            }
        } else {
            resp.getWriter().append(response);
            resp.flushBuffer();
        }
    }

    protected DispatchReturn handleUnexpectedException(Exception e) {
        RaptureException raptException = RaptureExceptionFactory.create((Integer)500, (String)"Unknown error", (Throwable)e);
        String response = BaseDispatcher.error((RaptureException)raptException);
        log.error((Object)raptException.getFormattedMessage());
        Kernel.writeAuditEntry((String)"exception", (int)2, (String)e.getMessage());
        return new DispatchReturn(response);
    }
}

