/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import rapture.common.BlobContainer;
import rapture.common.CallingContext;
import rapture.common.DispatchReturn;
import rapture.common.EntitlementSet;
import rapture.common.exception.RaptNotLoggedInException;
import rapture.common.model.BasePayload;
import rapture.common.shared.blob.GetBlobPayload;
import rapture.kernel.BlobApiImplWrapper;
import rapture.kernel.ContextFactory;
import rapture.kernel.Kernel;
import rapture.kernel.context.ContextValidator;
import rapture.server.BaseDispatcher;
import rapture.server.web.servlet.BaseServlet;

@MultipartConfig
public class BlobContentServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static final String BLOB_URI_PREFIX = "blob://";
    private static Logger log = Logger.getLogger(BlobContentServlet.class);
    private String blobRepo;
    private boolean checkCredentials = false;
    private boolean checkEntitlements = false;
    private String redirect = null;
    private List<String> templateMimeTypes = new ArrayList<String>();
    private String pageTemplate = null;

    public void init() throws ServletException {
        String checkEntsString;
        log.info((Object)"INITIALIZING....");
        this.blobRepo = this.getServletConfig().getInitParameter("repo");
        if (this.blobRepo == null) {
            throw new ServletException("No folder parameter");
        }
        String checkCredsString = this.getServletConfig().getInitParameter("check");
        if (checkCredsString != null) {
            this.checkCredentials = Boolean.valueOf(checkCredsString);
        }
        if ((checkEntsString = this.getServletConfig().getInitParameter("entitlements")) != null) {
            this.checkEntitlements = Boolean.valueOf(checkEntsString);
        }
        this.redirect = this.getServletConfig().getInitParameter("redirectOnAuthFail");
        String templateCheck = this.getServletConfig().getInitParameter("templates");
        if (templateCheck != null) {
            String[] parts;
            for (String p : parts = templateCheck.split(",")) {
                this.templateMimeTypes.add(p);
            }
        }
        this.pageTemplate = this.getServletConfig().getInitParameter("pageTemplate");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String blobPath = req.getRequestURI();
        if (blobPath.equals("/")) {
            blobPath = "/index.html";
        }
        CallingContext callingContext = null;
        if (this.checkCredentials) {
            try {
                callingContext = BaseDispatcher.validateSession((HttpServletRequest)req);
            }
            catch (RaptNotLoggedInException re) {
                log.error((Object)re.getMessage());
                if (this.redirect != null) {
                    resp.sendRedirect(this.redirect);
                } else {
                    resp.sendError(re.getStatus().intValue(), re.getMessage());
                }
                return;
            }
            if (callingContext == null || !callingContext.getValid().booleanValue()) {
                log.error((Object)"Calling Context is not valid");
                if (this.redirect != null) {
                    resp.sendRedirect(this.redirect);
                } else {
                    resp.sendError(401, "Must be logged in");
                }
                return;
            }
        } else {
            callingContext = ContextFactory.getKernelUser();
        }
        if (this.checkEntitlements) {
            GetBlobPayload requestObj = new GetBlobPayload();
            requestObj.setContext(callingContext);
            requestObj.setBlobUri(blobPath);
            ContextValidator.validateContext((CallingContext)callingContext, (EntitlementSet)EntitlementSet.Blob_getBlob, (BasePayload)requestObj);
        }
        try {
            if (blobPath.startsWith("/t/app/")) {
                this.streamTemplatedBlob(resp, blobPath.substring(2), callingContext);
            } else {
                this.streamBlob(resp, blobPath, callingContext, true);
            }
        }
        catch (Exception e) {
            DispatchReturn response = this.handleUnexpectedException(e);
            this.sendResponseAppropriately(response.getContext(), req, resp, response.getResponse());
        }
    }

    private void streamBlob(HttpServletResponse resp, String blobPath, CallingContext callingContext, boolean outer) throws IOException {
        String uri;
        BlobApiImplWrapper blob = Kernel.getBlob();
        BlobContainer blobContainer = blob.getBlob(callingContext, uri = BLOB_URI_PREFIX + this.blobRepo + blobPath);
        if (blobContainer != null) {
            String contentType;
            boolean performTemplating = false;
            if (blobContainer.getHeaders() != null && (contentType = (String)blobContainer.getHeaders().get("Content-Type")) != null) {
                if (outer) {
                    resp.setContentType(contentType);
                }
                if (this.templateMimeTypes.contains(contentType)) {
                    performTemplating = true;
                }
            }
            if (outer) {
                resp.setStatus(200);
            }
            if (performTemplating) {
                this.templateParse(callingContext, resp, blobContainer.getContent());
            } else {
                resp.getOutputStream().write(blobContainer.getContent());
            }
        } else {
            log.error((Object)("No blob at " + uri));
            if (outer) {
                resp.setStatus(404);
            }
        }
    }

    private void streamTemplatedBlob(HttpServletResponse resp, String blobPath, CallingContext callingContext) throws IOException {
        String uri = BLOB_URI_PREFIX + this.blobRepo + this.pageTemplate;
        BlobContainer blobContainer = Kernel.getBlob().getBlob(callingContext, uri);
        if (blobContainer != null) {
            String content = new String(blobContainer.getContent());
            content = content.replace("/path/to/main/content", blobPath);
            resp.getOutputStream().write(content.getBytes());
        } else {
            log.error((Object)("No blob at " + uri));
            resp.setStatus(404);
        }
    }

    private void templateParse(CallingContext callingContext, HttpServletResponse resp, byte[] content) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(content)));
        while ((line = reader.readLine()) != null) {
            boolean noMore = false;
            int point = 0;
            while (!noMore) {
                int startPoint = line.indexOf("{{{", point);
                if (startPoint == -1) {
                    noMore = true;
                    continue;
                }
                log.info((Object)("Template at position " + startPoint + " on line " + line.substring(point)));
                resp.getOutputStream().write(line.substring(point, startPoint).getBytes());
                point = startPoint;
                int endPoint = line.indexOf("}}}", point);
                if (endPoint != 1) {
                    String inner = line.substring(point + 2, endPoint).trim();
                    log.info((Object)("Inner template is " + inner));
                    point = endPoint + 2;
                    this.streamBlob(resp, inner, callingContext, false);
                    continue;
                }
                log.info((Object)"No endpoint for startpoint");
            }
            resp.getOutputStream().write(line.substring(point).getBytes());
        }
        reader.close();
    }
}

