/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import rapture.common.BlobContainer;
import rapture.common.CallingContext;
import rapture.common.DispatchReturn;
import rapture.common.exception.RaptNotLoggedInException;
import rapture.common.shared.blob.DispatchBlobFunction;
import rapture.kernel.BlobApiImplWrapper;
import rapture.kernel.Kernel;
import rapture.server.BaseDispatcher;
import rapture.server.web.servlet.BaseServlet;
import rapture.server.web.servlet.StandardCallInfo;

@WebServlet(urlPatterns={"/blob", "/blob/*"})
@MultipartConfig
public class BlobServlet
extends BaseServlet {
    private static final long serialVersionUID = -654951209810427391L;
    private static final String BLOB_URI_PREFIX = "blob:/";
    private static Logger log = Logger.getLogger(BlobServlet.class);

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        DispatchReturn response;
        StandardCallInfo call = this.processFunctionalRequest(req);
        DispatchBlobFunction blobDispatch = DispatchBlobFunction.valueOf((String)call.getFunctionName());
        try {
            response = blobDispatch.executeDispatch(call.getContent(), req, resp);
        }
        catch (Exception e) {
            response = this.handleUnexpectedException(e);
        }
        this.sendResponseAppropriately(response.getContext(), req, resp, response.getResponse());
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String blobPath = req.getPathInfo();
        CallingContext callingContext = null;
        try {
            callingContext = BaseDispatcher.validateSession((HttpServletRequest)req);
        }
        catch (RaptNotLoggedInException re) {
            log.error((Object)re.getMessage());
            resp.sendError(re.getStatus().intValue(), re.getMessage());
        }
        if (!callingContext.getValid().booleanValue()) {
            log.error((Object)"Calling Context is not valid");
            resp.sendError(401, "Must be logged in");
        }
        BlobApiImplWrapper blob = Kernel.getBlob();
        try {
            BlobContainer blobContainer = blob.getBlob(callingContext, BLOB_URI_PREFIX + blobPath);
            if (blobContainer != null) {
                String contentType;
                if (blobContainer.getHeaders() != null && (contentType = (String)blobContainer.getHeaders().get("Content-Type")) != null) {
                    resp.setContentType(contentType);
                }
                resp.setStatus(200);
                resp.getOutputStream().write(blobContainer.getContent());
            } else {
                resp.setStatus(404);
            }
        }
        catch (Exception e) {
            DispatchReturn response = this.handleUnexpectedException(e);
            this.sendResponseAppropriately(response.getContext(), req, resp, response.getResponse());
        }
    }
}

