/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.apache.log4j.Logger;
import rapture.common.CallingContext;
import rapture.common.DispatchReturn;
import rapture.common.RaptureScriptLanguage;
import rapture.common.RaptureScriptPurpose;
import rapture.common.RaptureURI;
import rapture.common.Scheme;
import rapture.common.exception.RaptNotLoggedInException;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.kernel.Kernel;
import rapture.server.BaseDispatcher;
import rapture.server.web.servlet.BaseServlet;
import rapture.util.MimeTypeResolver;

@WebServlet(value={"/blobupload"})
@MultipartConfig
public class BlobUploadServlet
extends BaseServlet {
    private static final long serialVersionUID = 7598856450379496544L;
    private static Logger log = Logger.getLogger(BlobUploadServlet.class);
    private static MimeTypeResolver resolver = new MimeTypeResolver();

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        CallingContext context = null;
        try {
            context = BaseDispatcher.validateSession((HttpServletRequest)request);
        }
        catch (RaptNotLoggedInException re) {
            log.error((Object)re.getMessage());
            response.sendError(re.getStatus().intValue(), re.getMessage());
        }
        if (!context.getValid().booleanValue()) {
            log.error((Object)"Calling Context is not valid");
            response.sendError(401, "Must be logged in");
        }
        String description = request.getParameter("description");
        RaptureURI uri = new RaptureURI(description, Scheme.BLOB);
        Part filePart = request.getPart("file");
        try {
            switch (uri.getScheme()) {
                case BLOB: {
                    this.storeBlob(context, filePart, uri, description);
                    break;
                }
                case SCRIPT: {
                    this.storeScript(context, filePart, uri, description);
                    break;
                }
                case DOCUMENT: {
                    this.storeDocument(context, filePart, uri, description);
                    break;
                }
                default: {
                    throw RaptureExceptionFactory.create((String)"Could not work with that scheme");
                }
            }
            log.info((Object)("URI is " + description));
            response.sendRedirect(request.getHeader("referer"));
        }
        catch (Exception e) {
            DispatchReturn dispatchReturn = this.handleUnexpectedException(e);
            this.sendResponseAppropriately(dispatchReturn.getContext(), request, response, dispatchReturn.getResponse());
        }
    }

    private void storeDocument(CallingContext context, Part filePart, RaptureURI uri, String description) throws IOException {
        String shortPath = uri.getShortPath();
        byte[] data = this.getByteContentFromPart(filePart);
        String content = new String(data);
        Kernel.getDoc().putDoc(context, shortPath, content);
    }

    private void storeScript(CallingContext context, Part filePart, RaptureURI uri, String description) throws IOException {
        String shortPath = uri.getShortPath();
        log.info((Object)("Attempting to store script at " + shortPath));
        byte[] data = this.getByteContentFromPart(filePart);
        String script = new String(data);
        Kernel.getScript().createScript(context, shortPath, RaptureScriptLanguage.REFLEX, RaptureScriptPurpose.PROGRAM, script);
    }

    private void storeBlob(CallingContext context, Part filePart, RaptureURI uri, String description) throws IOException {
        String shortPath = uri.getShortPath();
        byte[] data = this.getByteContentFromPart(filePart);
        log.info((Object)("Size of data is " + data.length));
        String fileName = BlobUploadServlet.getFilename(filePart);
        String mimeType = resolver.getMimeType(resolver.getExtensionFromPath(fileName));
        Kernel.getBlob().putBlob(context, shortPath, data, mimeType);
    }

    private static String getFilename(Part part) {
        for (String cd : part.getHeader("content-disposition").split(";")) {
            if (!cd.trim().startsWith("filename")) continue;
            String filename = cd.substring(cd.indexOf(61) + 1).trim().replace("\"", "");
            return filename.substring(filename.lastIndexOf(47) + 1).substring(filename.lastIndexOf(92) + 1);
        }
        return null;
    }
}

