/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import rapture.common.BlobContainer;
import rapture.common.CallingContext;
import rapture.common.DispatchReturn;
import rapture.common.exception.RaptNotLoggedInException;
import rapture.common.shared.jar.DispatchJarFunction;
import rapture.kernel.JarApiImplWrapper;
import rapture.kernel.Kernel;
import rapture.server.BaseDispatcher;
import rapture.server.web.servlet.BaseServlet;
import rapture.server.web.servlet.StandardCallInfo;

@WebServlet(urlPatterns={"/jar", "/jar/*"})
@MultipartConfig
public class JarServlet
extends BaseServlet {
    private static final long serialVersionUID = -42L;
    private static final String JAR_URI_PREFIX = "jar:/";
    private static Logger log = Logger.getLogger(JarServlet.class);

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        DispatchReturn response;
        StandardCallInfo call = this.processFunctionalRequest(req);
        DispatchJarFunction jarDispatch = DispatchJarFunction.valueOf((String)call.getFunctionName());
        try {
            response = jarDispatch.executeDispatch(call.getContent(), req, resp);
        }
        catch (Exception e) {
            response = this.handleUnexpectedException(e);
        }
        this.sendResponseAppropriately(response.getContext(), req, resp, response.getResponse());
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String jarPath = req.getPathInfo();
        CallingContext callingContext = null;
        try {
            callingContext = BaseDispatcher.validateSession((HttpServletRequest)req);
        }
        catch (RaptNotLoggedInException re) {
            log.error((Object)re.getMessage());
            resp.sendError(re.getStatus().intValue(), re.getMessage());
        }
        if (!callingContext.getValid().booleanValue()) {
            log.error((Object)"Calling Context is not valid");
            resp.sendError(401, "Must be logged in");
        }
        JarApiImplWrapper jar = Kernel.getJar();
        try {
            BlobContainer jarContainer = jar.getJar(callingContext, JAR_URI_PREFIX + jarPath);
            if (jarContainer != null) {
                String contentType;
                if (jarContainer.getHeaders() != null && (contentType = (String)jarContainer.getHeaders().get("Content-Type")) != null) {
                    resp.setContentType(contentType);
                }
                resp.setStatus(200);
                resp.getOutputStream().write(jarContainer.getContent());
            } else {
                resp.setStatus(404);
            }
        }
        catch (Exception e) {
            DispatchReturn response = this.handleUnexpectedException(e);
            this.sendResponseAppropriately(response.getContext(), req, resp, response.getResponse());
        }
    }
}

