/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import rapture.common.CallingContext;
import rapture.common.DispatchReturn;
import rapture.common.RaptureScript;
import rapture.common.RaptureURI;
import rapture.common.exception.RaptNotLoggedInException;
import rapture.kernel.ContextFactory;
import rapture.kernel.Kernel;
import rapture.server.BaseDispatcher;
import rapture.server.web.servlet.BaseServlet;

public class JavaScriptPageServlet
extends BaseServlet {
    private static final long serialVersionUID = 8271972998410468347L;
    private static Logger logger = Logger.getLogger(JavaScriptPageServlet.class);
    private String scriptPrefix;

    public void init() throws ServletException {
        logger.info((Object)"INITIALIZING....");
        this.scriptPrefix = this.getServletConfig().getInitParameter("prefix");
        if (this.scriptPrefix == null) {
            throw new ServletException("No prefix parameter");
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = req.getParameter(key);
            parameterMap.put(key, val);
        }
        this.process(parameterMap, req, resp);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        HashMap<String, String> parameterMap = new HashMap<String, String>();
        Map<String, Object> props = this.getParams(req);
        for (String key : props.keySet()) {
            Object val = props.get(key);
            String valStr = null;
            if (val instanceof String) {
                valStr = URLDecoder.decode((String)val, "UTF-8");
            } else if (val != null) {
                valStr = val.toString();
            }
            parameterMap.put(key, valStr);
        }
        this.process(parameterMap, req, resp);
    }

    private void process(Map<String, String> parameterMap, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        logger.debug((Object)("req is " + req));
        logger.debug((Object)("resp is " + resp));
        logger.debug((Object)("parameterMap is " + parameterMap));
        RaptureURI scriptURI = this.getScriptURI(req);
        logger.info((Object)String.format("Running script for uri %s", scriptURI.toString()));
        RaptureScript script = Kernel.getScript().getScript(ContextFactory.ADMIN, scriptURI.toString());
        if (script == null || StringUtils.isBlank((CharSequence)script.getScript())) {
            logger.warn((Object)("Could not locate script for uri - " + scriptURI.toString()));
            resp.setStatus(404);
            return;
        }
        try {
            CallingContext context = BaseDispatcher.validateSession((HttpServletRequest)req);
            if (context != null) {
                logger.trace((Object)("Got session context " + context.debug()));
                String result = Kernel.getScript().runScript(context, scriptURI.getFullPath(), parameterMap);
                resp.setCharacterEncoding("UTF-8");
                resp.getWriter().append(result);
                resp.setContentType("text/plain");
            } else {
                String err = "Cannot execute script " + script + " : cannot get session context for authorization";
                logger.error((Object)err);
                resp.sendError(401, err);
            }
        }
        catch (RaptNotLoggedInException re) {
            logger.error((Object)("Cannot execute script " + script + " : " + re.getMessage()));
            resp.sendError(re.getStatus().intValue(), re.getMessage());
        }
        catch (Exception e) {
            DispatchReturn response = this.handleUnexpectedException(e);
            this.sendResponseAppropriately(response.getContext(), req, resp, response.getResponse());
        }
    }

    private RaptureURI getScriptURI(HttpServletRequest req) {
        String scriptName = req.getPathInfo();
        return new RaptureURI(this.scriptPrefix + scriptName);
    }
}

