/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import rapture.jmx.JmxApp;
import rapture.jmx.JmxAppCache;
import rapture.server.web.servlet.BaseServlet;

@WebServlet(urlPatterns={"/jmx"})
public class JmxServlet
extends BaseServlet {
    private static final long serialVersionUID = -5651493694360781626L;
    private static final Logger log = Logger.getLogger(JmxServlet.class);

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        block29: {
            String path = req.getPathInfo();
            if (StringUtils.isNotBlank((CharSequence)path)) {
                JmxApp app;
                int index = (path = this.stripLeadingSlash(path)).indexOf(47);
                if (index == -1) {
                    this.error(res, "Invalid URL path provided");
                    return;
                }
                String appName = path.substring(0, index);
                path = path.substring(index);
                try {
                    app = (JmxApp)JmxAppCache.getInstance().get().get(appName);
                }
                catch (ExecutionException e) {
                    this.error(res, e.getMessage());
                    return;
                }
                if (app == null) {
                    this.error(res, String.format("App [%s] not found", appName));
                    return;
                }
                try (InputStream input = new URL(app.getUrl() + path).openStream();
                     ServletOutputStream output = res.getOutputStream();){
                    IOUtils.copy((InputStream)input, (OutputStream)output);
                    break block29;
                }
            }
            this.error(res, path + " is unavailable");
        }
    }

    private void error(HttpServletResponse res, String msg) throws IOException {
        log.error((Object)("Error forwarding jmx request: " + msg));
        res.sendError(404, msg);
    }

    private String stripLeadingSlash(String path) {
        return path.trim().substring(1);
    }
}

