/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.MultipartConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import rapture.common.DispatchReturn;
import rapture.common.exception.RaptureException;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.kernel.Kernel;
import rapture.server.BaseDispatcher;
import rapture.server.login.LoginDispatchEnum;
import rapture.server.web.servlet.BaseServlet;
import rapture.server.web.servlet.StandardCallInfo;

@MultipartConfig
public class LoginServlet
extends BaseServlet {
    private static final long serialVersionUID = -4771514093502324701L;
    private static Logger log = Logger.getLogger(LoginServlet.class);

    private boolean checkIPAddressValid(String remoteAddr) {
        return Kernel.getKernel().checkIPAddress(remoteAddr);
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        DispatchReturn response;
        if (this.checkIPAddressValid(req.getRemoteAddr())) {
            StandardCallInfo call = this.processFunctionalRequest(req);
            LoginDispatchEnum loginDispatch = LoginDispatchEnum.valueOf((String)call.getFunctionName());
            try {
                response = loginDispatch.executeDispatch(call.getContent(), req, resp);
            }
            catch (Exception e) {
                response = this.handleUnexpectedException(e);
            }
        } else {
            RaptureException raptException = RaptureExceptionFactory.create((Integer)401, (String)String.format("IP Address not approved for access", req.getRemoteAddr()));
            response = new DispatchReturn(BaseDispatcher.error((RaptureException)raptException));
        }
        this.sendResponseAppropriately(response.getContext(), req, resp, response.getResponse());
    }
}

