/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import rapture.common.DispatchReturn;
import rapture.common.impl.jackson.JacksonUtil;
import rapture.server.web.servlet.BaseServlet;
import rapture.util.ResourceLoader;

public class MenuConfigServlet
extends BaseServlet {
    private String folder;
    private static Logger log = Logger.getLogger(MenuConfigServlet.class);
    private static final long serialVersionUID = 2930792109818985861L;

    public void init() throws ServletException {
        log.info((Object)"INITIALIZING....");
        this.folder = this.getServletConfig().getInitParameter("folder");
        if (this.folder == null) {
            throw new ServletException("No folder parameter");
        }
        if (!this.folder.endsWith("/")) {
            this.folder = this.folder + "/";
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            ServletContext context = this.getServletContext();
            Set files = context.getResourcePaths(this.folder);
            log.info((Object)("Search for " + this.folder + " yielded " + files.toString()));
            ArrayList configs = new ArrayList();
            for (String f : files) {
                log.info((Object)("Looking at " + f));
                InputStream is = context.getResourceAsStream(f);
                String content = ResourceLoader.getResourceFromInputStream((InputStream)is);
                log.info((Object)("Content is " + content));
                List menus = (List)JacksonUtil.objectFromJson((String)content, List.class);
                configs.addAll(menus);
            }
            Collections.sort(configs, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    Map ao1 = (Map)o1;
                    Map ao2 = (Map)o2;
                    if (ao1.containsKey("rank") && ao2.containsKey("rank")) {
                        return (Integer)ao1.get("rank") < (Integer)ao2.get("rank") ? -1 : 1;
                    }
                    return 1;
                }
            });
            String mergedContent = JacksonUtil.jsonFromObject(configs);
            resp.setStatus(200);
            resp.setCharacterEncoding("UTF-8");
            resp.getWriter().append(mergedContent);
            resp.setContentType("text/plain");
            resp.flushBuffer();
        }
        catch (Exception e) {
            DispatchReturn response = this.handleUnexpectedException(e);
            this.sendResponseAppropriately(response.getContext(), req, resp, response.getResponse());
        }
    }
}

