/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import rapture.common.CallingContext;
import rapture.common.DispatchReturn;
import rapture.common.RaptureFolderInfo;
import rapture.common.RaptureScript;
import rapture.common.exception.RaptNotLoggedInException;
import rapture.common.impl.jackson.JacksonUtil;
import rapture.kernel.Kernel;
import rapture.kernel.script.KernelScript;
import rapture.server.BaseDispatcher;
import rapture.server.web.servlet.BaseServlet;
import rapture.server.web.servlet.ReflexScriptPageHandler;
import rapture.server.web.servlet.micro.MicroService;
import rapture.server.web.servlet.micro.MicroServiceException;
import rapture.server.web.servlet.micro.MicroServiceParam;
import reflex.IReflexHandler;
import reflex.ReflexExecutor;

public class MicroServiceServlet
extends BaseServlet {
    private static final long serialVersionUID = -1275872776877337688L;
    private static Logger log = Logger.getLogger(MicroServiceServlet.class);
    private String serviceDefLocation;

    public void init() throws ServletException {
        this.serviceDefLocation = this.getServletConfig().getInitParameter("service");
        if (this.serviceDefLocation == null) {
            throw new ServletException("No service parameter");
        }
        if (this.serviceDefLocation.endsWith("/")) {
            this.serviceDefLocation = this.serviceDefLocation.substring(0, this.serviceDefLocation.length() - 1);
        }
    }

    private CallingContext getCallingContext(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        CallingContext callingContext = null;
        try {
            callingContext = BaseDispatcher.validateSession((HttpServletRequest)req);
        }
        catch (RaptNotLoggedInException re) {
            log.error((Object)re.getMessage());
            resp.sendError(re.getStatus().intValue(), re.getMessage());
        }
        if (callingContext == null || !callingContext.getValid().booleanValue()) {
            log.error((Object)"Calling Context is not valid");
            resp.sendError(401, "Must be logged in");
            return null;
        }
        return callingContext;
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        Map<String, Object> props = this.getParams(req);
        try {
            CallingContext context = this.getCallingContext(req, resp);
            if (context != null) {
                this.process(context, req, resp, props);
            }
        }
        catch (Exception ex) {
            DispatchReturn response = this.handleUnexpectedException(ex);
            this.sendResponseAppropriately(response.getContext(), req, resp, response.getResponse());
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = req.getParameter(key);
            parameterMap.put(key, val);
        }
        try {
            CallingContext context = this.getCallingContext(req, resp);
            if (context != null) {
                this.process(context, req, resp, parameterMap);
            }
        }
        catch (Exception ex) {
            DispatchReturn response = this.handleUnexpectedException(ex);
            this.sendResponseAppropriately(response.getContext(), req, resp, response.getResponse());
        }
    }

    private void process(CallingContext context, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> parameterMap) throws IOException {
        try {
            if (parameterMap.containsKey("info")) {
                this.processInfoRequest(context, req, resp);
            } else {
                this.processExecRequest(context, req, resp, parameterMap);
            }
        }
        catch (MicroServiceException e) {
            e.sendResponse(resp);
        }
    }

    private void processExecRequest(CallingContext context, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> parameterMap) throws IOException, MicroServiceException {
        String uri = this.serviceDefLocation + req.getPathInfo();
        String content = Kernel.getDoc().getDoc(context, uri);
        if (content == null) {
            throw new MicroServiceException(404, "No micro service");
        }
        MicroService service = (MicroService)JacksonUtil.objectFromJson((String)content, MicroService.class);
        if (service == null) {
            throw new MicroServiceException(400, "Invalid micro service");
        }
        this.execService(service, context, req, resp, parameterMap);
    }

    private void execService(MicroService service, CallingContext context, HttpServletRequest req, HttpServletResponse resp, Map<String, Object> parameterMap) throws MicroServiceException, IOException {
        Map<String, Object> coercedParameters = this.getCoercedParameters(service, parameterMap);
        ReflexScriptPageHandler handler = new ReflexScriptPageHandler();
        KernelScript kScript = new KernelScript();
        kScript.setCallingContext(context);
        handler.setScriptApi(kScript);
        RaptureScript s = Kernel.getScript().getScript(context, service.getService());
        if (s == null) {
            throw new MicroServiceException(400, "Script " + service.getService() + " not found");
        }
        Object ret = ReflexExecutor.runReflexProgram((String)s.getScript(), (IReflexHandler)handler, coercedParameters);
        resp.setCharacterEncoding("UTF-8");
        switch (service.getReturns().getFrom()) {
            case "output": {
                resp.getWriter().append(handler.getOutput());
                break;
            }
            case "return": {
                resp.getWriter().append(ret.toString());
                break;
            }
            default: {
                throw new MicroServiceException(400, "Unknown return type " + service.getReturns().getFrom());
            }
        }
        resp.setContentType(service.getReturns().getType());
    }

    private Map<String, Object> getCoercedParameters(MicroService service, Map<String, Object> parameterMap) throws MicroServiceException {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (MicroServiceParam p : service.getParams()) {
            if (parameterMap.containsKey(p.getName())) {
                ret.put(p.getName(), this.coerceValue(parameterMap.get(p.getName()), p.getType()));
                continue;
            }
            throw new MicroServiceException(400, "Parameter " + p.getName() + " not found");
        }
        return ret;
    }

    private Object coerceValue(Object object, String type) throws MicroServiceException {
        switch (type) {
            case "text": {
                return object.toString();
            }
            case "number": {
                try {
                    Integer v = Integer.parseInt(object.toString());
                    return v;
                }
                catch (NumberFormatException e) {
                    try {
                        Double v = Double.parseDouble(object.toString());
                        return v;
                    }
                    catch (NumberFormatException e2) {
                        throw new MicroServiceException(400, "Value " + object.toString() + " cannot be coerced to a number");
                    }
                }
            }
        }
        throw new MicroServiceException(400, "Unknown parameter type " + type);
    }

    private void processInfoRequest(CallingContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String uri = this.serviceDefLocation + req.getPathInfo();
        String content = Kernel.getDoc().getDoc(context, uri);
        if (content != null) {
            resp.getOutputStream().write(content.getBytes());
        } else {
            Map infoMap = Kernel.getDoc().listDocsByUriPrefix(context, uri, 1);
            ArrayList<RaptureFolderInfo> info = new ArrayList<RaptureFolderInfo>();
            for (RaptureFolderInfo rfi : infoMap.values()) {
                info.add(rfi);
            }
            resp.getOutputStream().write(JacksonUtil.jsonFromObject(info).getBytes());
        }
        resp.setContentType("application/json");
        resp.flushBuffer();
    }
}

