/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import rapture.common.RaptureScript;
import rapture.common.RaptureURI;
import rapture.kernel.ContextFactory;
import rapture.kernel.Kernel;
import rapture.server.web.servlet.BaseReflexScriptPageServlet;

public class ReflexBoundedScriptPageServlet
extends BaseReflexScriptPageServlet {
    private static final long serialVersionUID = -1275872776877337688L;
    private static Logger log = Logger.getLogger(ReflexBoundedScriptPageServlet.class);
    private String scriptPrefix;

    public void init() throws ServletException {
        log.info((Object)"INITIALIZING....");
        this.scriptPrefix = this.getServletConfig().getInitParameter("prefix");
        if (this.scriptPrefix == null) {
            throw new ServletException("No prefix parameter");
        }
    }

    @Override
    protected String getPrintableScript(HttpServletRequest req) {
        RaptureURI uri = this.getScriptURI(req);
        return uri.toString();
    }

    private RaptureURI getScriptURI(HttpServletRequest req) {
        String scriptName = req.getPathInfo();
        return new RaptureURI(this.scriptPrefix + scriptName);
    }

    @Override
    protected String getReflexScript(HttpServletRequest req) {
        RaptureURI scriptURI = this.getScriptURI(req);
        log.info((Object)String.format("Running script for uri %s", scriptURI.toString()));
        RaptureScript script = Kernel.getScript().getScript(ContextFactory.ADMIN, scriptURI.toString());
        if (script != null) {
            return script.getScript();
        }
        log.warn((Object)("Could not locate script for uri - " + scriptURI.toString()));
        return null;
    }
}

