/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import rapture.common.RaptureScript;
import rapture.common.RaptureURI;
import rapture.common.Scheme;
import rapture.kernel.ContextFactory;
import rapture.kernel.Kernel;
import rapture.server.web.servlet.BaseReflexScriptPageServlet;

public class ReflexRefScriptPageServlet
extends BaseReflexScriptPageServlet {
    private static final long serialVersionUID = -1275872776877337688L;
    private static Logger log = Logger.getLogger(ReflexRefScriptPageServlet.class);

    @Override
    protected String getPrintableScript(HttpServletRequest req) {
        RaptureURI uri = this.getScriptURI(req);
        return uri.toString();
    }

    private RaptureURI getScriptURI(HttpServletRequest req) {
        String scriptName = req.getServletPath().substring(1);
        int firstPartPoint = scriptName.indexOf("/");
        int lastDecPoint = scriptName.lastIndexOf(46);
        String authority = scriptName.substring(0, firstPartPoint);
        String name = scriptName.substring(firstPartPoint + 1, lastDecPoint);
        return RaptureURI.builder((Scheme)Scheme.SCRIPT, (String)authority).docPath(name).build();
    }

    @Override
    protected String getReflexScript(HttpServletRequest req) {
        RaptureURI scriptURI = this.getScriptURI(req);
        log.debug((Object)String.format("Running script for uri %s", scriptURI.toString()));
        RaptureScript script = Kernel.getScript().getScript(ContextFactory.ADMIN, scriptURI.toString());
        if (script != null) {
            return script.getScript();
        }
        log.warn((Object)("Could not locate script for uri - " + scriptURI.toString()));
        return null;
    }
}

