/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import rapture.common.exception.ExceptionToString;
import rapture.server.web.servlet.BaseReflexScriptPageServlet;
import rapture.util.ResourceLoader;

public class ReflexScriptPageServlet
extends BaseReflexScriptPageServlet {
    private static final long serialVersionUID = 1713902342313464871L;
    private static Logger log = Logger.getLogger(ReflexScriptPageServlet.class);
    private static final int MAX_PRINTABLE_SIZE = 50;

    @Override
    protected String getPrintableScript(HttpServletRequest req) {
        String scriptBody = this.getReflexScript(req);
        if (StringUtils.isEmpty((String)scriptBody)) {
            return "<script not found>";
        }
        if (scriptBody.length() > 50) {
            return scriptBody.substring(0, 50);
        }
        return scriptBody;
    }

    @Override
    protected String getReflexScript(HttpServletRequest req) {
        ServletContext context = this.getServletContext();
        String result = null;
        try (InputStream is = context.getResourceAsStream(req.getServletPath());){
            if (is != null) {
                result = ResourceLoader.getResourceFromInputStream((InputStream)is);
            }
        }
        catch (IOException e) {
            log.error((Object)ExceptionToString.format((Throwable)e));
        }
        return result;
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
    }
}

