/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import java.io.IOException;
import java.text.DateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import rapture.common.CallingContext;
import rapture.common.RaptureFolderInfo;
import rapture.common.exception.RaptNotLoggedInException;
import rapture.common.exception.RaptureException;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.common.impl.jackson.JacksonUtil;
import rapture.common.model.DocumentMetadata;
import rapture.common.model.DocumentRepoConfig;
import rapture.kernel.ContextFactory;
import rapture.kernel.Kernel;
import rapture.server.BaseDispatcher;
import rapture.server.web.servlet.BaseServlet;
import rapture.server.web.servlet.rest.RestCollectionResponse;
import rapture.server.web.servlet.rest.RestFile;
import rapture.server.web.servlet.rest.RestFolder;

public class RestDocServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static Logger log = Logger.getLogger(RestDocServlet.class);

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String response;
        CallingContext context = ContextFactory.getKernelUser();
        try {
            log.info((Object)"Validing context");
            context = BaseDispatcher.validateSession((HttpServletRequest)req);
            if (context == null) {
                throw new RaptNotLoggedInException("Not logged in");
            }
            log.info((Object)("Context is for " + context.getUser()));
            String path = req.getPathInfo();
            response = path == null || path.length() == 1 && path.startsWith("/") ? this.processRootRequest(context) : this.processNonRootRequest(context, path);
        }
        catch (RaptureException e) {
            response = BaseDispatcher.error((RaptureException)e);
        }
        catch (Exception e) {
            response = BaseDispatcher.error((RaptureException)RaptureExceptionFactory.create((Integer)500, (String)"Could not handle rest request.", (Throwable)e));
        }
        this.sendResponseAppropriately(context, req, resp, response);
    }

    private String processRootRequest(CallingContext context) {
        RestCollectionResponse response = new RestCollectionResponse();
        response.setPath("/");
        List repos = Kernel.getDoc().getDocRepoConfigs(context);
        for (DocumentRepoConfig repo : repos) {
            RestFolder f = new RestFolder();
            f.setPath("/" + repo.getAuthority());
            f.setName(repo.getAuthority());
            response.getFolders().add(f);
        }
        return JacksonUtil.jsonFromObject((Object)response);
    }

    private String processNonRootRequest(CallingContext context, String path) {
        DateFormat df = DateFormat.getDateTimeInstance();
        if (path.charAt(0) == '/' && path.charAt(1) != '/') {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            RestCollectionResponse response = this.handleFolder(context, path, df);
            return JacksonUtil.jsonFromObject((Object)response);
        }
        String content = Kernel.getDoc().getDoc(context, path);
        if (content == null) {
            RestCollectionResponse response = this.handleFolder(context, path, df);
            return JacksonUtil.jsonFromObject((Object)response);
        }
        return content;
    }

    private RestCollectionResponse handleFolder(CallingContext context, String path, DateFormat df) {
        Map contentMap = Kernel.getDoc().listDocsByUriPrefix(context, path, 1);
        RestCollectionResponse response = new RestCollectionResponse();
        response.setPath(path);
        for (RaptureFolderInfo f : contentMap.values()) {
            if (f.isFolder()) {
                RestFolder fold = new RestFolder();
                fold.setPath(path + (path.endsWith("/") ? "" : "/") + f.getName() + "/");
                fold.setName(f.getName());
                response.getFolders().add(fold);
                continue;
            }
            RestFile file = new RestFile();
            file.setPath(path + (path.endsWith("/") ? "" : "/") + f.getName());
            file.setName(f.getName());
            DocumentMetadata meta = Kernel.getDoc().getDocMeta(context, file.getPath());
            if (meta != null) {
                file.setLastUser(meta.getUser());
                file.setLastVersion(meta.getVersion());
                file.setLastWriteTime(df.format(new Date(meta.getModifiedTimestamp())));
            }
            response.getFiles().add(file);
        }
        return response;
    }
}

