/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import rapture.common.ErrorWrapper;
import rapture.common.RaptureScript;
import rapture.common.RaptureURI;
import rapture.common.exception.ExceptionToString;
import rapture.common.exception.RaptureException;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.common.impl.jackson.JacksonUtil;
import rapture.kernel.ContextFactory;
import rapture.kernel.Kernel;
import rapture.kernel.script.KernelScript;
import rapture.server.web.servlet.BaseServlet;
import rapture.server.web.servlet.ControlResponse;
import rapture.server.web.servlet.ReflexScriptPageHandler;
import rapture.server.web.servlet.ResponseControl;
import rapture.server.web.servlet.ResponseCookie;
import reflex.IReflexHandler;
import reflex.ReflexException;
import reflex.ReflexExecutor;

public class SessionControlServlet
extends BaseServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(SessionControlServlet.class);
    private String scriptPrefix;

    public void init() throws ServletException {
        log.info((Object)"INITIALIZING....");
        this.scriptPrefix = this.getServletConfig().getInitParameter("prefix");
        if (this.scriptPrefix == null) {
            throw new ServletException("No prefix parameter");
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String path = req.getPathInfo();
        log.info((Object)("Path is " + path));
        String[] parts = path.split("/");
        String scriptName = parts[parts.length - 1];
        String scriptURL = this.scriptPrefix + scriptName;
        log.info((Object)("Script URL is " + scriptURL));
        String script = this.getReflexScript(scriptURL);
        if (script == null || script.isEmpty()) {
            resp.setStatus(404);
            return;
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = req.getParameter(key);
            parameterMap.put(key, val);
        }
        ResponseControl control = new ResponseControl();
        control = this.runScriptWithResponseControl(script, parameterMap, control, resp);
        log.info((Object)"Returned from run script");
        ControlResponse r = new ControlResponse();
        if (control != null) {
            log.info((Object)"Control is not null");
            for (Map.Entry<String, ResponseCookie> entry : control.getCookieMap().entrySet()) {
                if (entry.getValue().isDelete()) {
                    log.info((Object)"Remove cookie");
                    Cookie killMyCookie = new Cookie(entry.getKey(), null);
                    killMyCookie.setMaxAge(0);
                    killMyCookie.setPath(entry.getValue().getPath());
                    resp.addCookie(killMyCookie);
                    continue;
                }
                log.info((Object)"Add cookie");
                Cookie cookie = new Cookie(entry.getKey(), entry.getValue().getValue());
                cookie.setPath(entry.getValue().getPath());
                resp.addCookie(cookie);
            }
            log.info((Object)("Response code is " + control.getResponseCode()));
            if (control.getPageRedirection() != null && !control.getPageRedirection().isEmpty()) {
                log.info((Object)"Sending redirect");
                r.setRedirect(control.getPageRedirection());
            } else if (!StringUtils.isBlank((String)control.getMessage())) {
                r.setMessage(control.getMessage());
            }
            String content = JacksonUtil.jsonFromObject((Object)r);
            log.info((Object)("Sending back " + content));
            resp.getWriter().append(content);
        }
        resp.flushBuffer();
    }

    protected ResponseControl runScriptWithResponseControl(String script, Map<String, Object> parameterMap, ResponseControl control, HttpServletResponse resp) throws IOException {
        Map controlMap = JacksonUtil.getHashFromObject((Object)control);
        HashMap<String, Map<String, Object>> masterParameterMap = new HashMap<String, Map<String, Object>>();
        masterParameterMap.put("control", controlMap);
        masterParameterMap.put("web", parameterMap);
        ReflexScriptPageHandler handler = new ReflexScriptPageHandler();
        KernelScript kScript = new KernelScript();
        try {
            kScript.setCallingContext(ContextFactory.getKernelUser());
            handler.setScriptApi(kScript);
            ReflexExecutor.runReflexProgram((String)script, (IReflexHandler)handler, masterParameterMap);
            System.out.println(handler.getOutput());
            String controlContent = JacksonUtil.jsonFromObject(masterParameterMap.get("control"));
            log.info((Object)("Control content is " + controlContent));
            ResponseControl ret = (ResponseControl)JacksonUtil.objectFromJson((String)controlContent, ResponseControl.class);
            return ret;
        }
        catch (ReflexException re) {
            System.out.println(handler.getOutput());
            log.error((Object)ExceptionToString.format((Throwable)re));
            Throwable cause = re.getCause();
            if (cause == null) {
                cause = re;
            }
            while (cause.getCause() != null && !(cause instanceof RaptureException)) {
                cause = cause.getCause();
            }
            RaptureException rapEx = cause instanceof RaptureException ? (RaptureException)cause : (re.getMessage() != null ? RaptureExceptionFactory.create((String)("Error calling Reflex script: " + re.getMessage()), (Throwable)re) : RaptureExceptionFactory.create((String)"Error calling Reflex script", (Throwable)re));
            ErrorWrapper ew = new ErrorWrapper();
            ew.setStatus(rapEx.getStatus());
            ew.setMessage(rapEx.getMessage());
            ew.setId(rapEx.getId());
            this.sendVerboseError(resp, ew);
            return null;
        }
    }

    private void sendVerboseError(HttpServletResponse resp, ErrorWrapper ew) throws IOException {
        Map map = JacksonUtil.getHashFromObject((Object)ew);
        map.put("error", ew.getMessage());
        String r = JacksonUtil.jsonFromObject((Object)map);
        resp.setCharacterEncoding("UTF-8");
        resp.getWriter().append(r);
        resp.setContentType("text/plain");
    }

    protected String getReflexScript(String uri) {
        RaptureURI scriptURI = new RaptureURI(uri);
        log.debug((Object)String.format("Running script for uri %s", scriptURI.toString()));
        RaptureScript script = Kernel.getScript().getScript(ContextFactory.ADMIN, scriptURI.toString());
        if (script != null) {
            return script.getScript();
        }
        log.warn((Object)("Could not locate script for uri - " + scriptURI.toString()));
        return null;
    }
}

