/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.servlet;

import java.io.IOException;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;
import rapture.common.CallingContext;
import rapture.common.ErrorWrapper;
import rapture.common.RaptureScript;
import rapture.common.RaptureURI;
import rapture.common.exception.ExceptionToString;
import rapture.common.exception.RaptureException;
import rapture.common.exception.RaptureExceptionFactory;
import rapture.common.impl.jackson.JacksonUtil;
import rapture.common.model.ContextResponseData;
import rapture.kernel.Kernel;
import rapture.kernel.script.KernelScript;
import rapture.server.web.servlet.BaseServlet;
import rapture.server.web.servlet.ReflexScriptPageHandler;
import reflex.IReflexHandler;
import reflex.ReflexException;
import reflex.ReflexExecutor;

public class UserBoundedScriptPageServlet
extends BaseServlet {
    private static CallingContext DEFINEDUSER = null;
    private static final long serialVersionUID = 1L;
    private static final Logger log = Logger.getLogger(UserBoundedScriptPageServlet.class);
    private String scriptPrefix;
    private String user;

    public void init() throws ServletException {
        log.debug((Object)"Starting UserBoundedScriptPageServlet");
        this.scriptPrefix = this.getServletConfig().getInitParameter("prefix");
        if (this.scriptPrefix == null) {
            throw new ServletException("No prefix parameter");
        }
        this.user = this.getServletConfig().getInitParameter("user");
        if (this.user == null) {
            throw new ServletException("No user parameter");
        }
        try {
            ContextResponseData contextForUser = Kernel.getLogin().getContextForUser(this.user);
            DEFINEDUSER = new CallingContext();
            DEFINEDUSER.setContext(contextForUser.getContextId());
            DEFINEDUSER.setUser(this.user);
            DEFINEDUSER.setValid(Boolean.valueOf(true));
        }
        catch (RaptureException re) {
            throw new ServletException("Error looking up user. " + re.getMessage());
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException, ServletException {
        Map<String, Object> requestVariables = this.getRequestVariables(req);
        log.debug((Object)("req is " + req));
        log.debug((Object)("resp is " + resp));
        log.debug((Object)("request variables " + requestVariables));
        if (Integer.valueOf(req.getHeader("content-length")) == 0) {
            log.debug((Object)"Request has no parameters.");
            resp.sendError(400, "Request has no parameters");
            return;
        }
        String scriptURL = this.getScriptUrlFromHttpRequest(req);
        if (scriptURL == null) {
            resp.sendError(400, "Request is missing path information.");
            return;
        }
        String script = this.getReflexScript(scriptURL);
        if (script == null || script.isEmpty()) {
            resp.sendError(404, "Service " + scriptURL + " has no endpoint");
            return;
        }
        Map<String, Object> props = this.getParams(req);
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        for (String key : props.keySet()) {
            Object val = props.get(key);
            if (val instanceof String) {
                val = URLDecoder.decode((String)val, "UTF-8");
            }
            parameterMap.put(key, val);
        }
        this.runScriptWithUser(script, parameterMap, resp);
        log.debug((Object)("Finished running script: " + scriptURL));
        resp.flushBuffer();
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String scriptURL = this.getScriptUrlFromHttpRequest(req);
        if (scriptURL == null) {
            resp.sendError(400, "Request is missing path information.");
            return;
        }
        String script = this.getReflexScript(scriptURL);
        if (script == null || script.isEmpty()) {
            resp.sendError(404, "Service " + scriptURL + " has no endpoint");
            return;
        }
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String val = req.getParameter(key);
            parameterMap.put(key, val);
        }
        this.runScriptWithUser(script, parameterMap, resp);
        log.debug((Object)("Finished running script: " + scriptURL));
        resp.flushBuffer();
    }

    protected void runScriptWithUser(String script, Map<String, Object> parameterMap, HttpServletResponse resp) throws IOException {
        HashMap<String, Map<String, Object>> masterParameterMap = new HashMap<String, Map<String, Object>>();
        masterParameterMap.put("web", parameterMap);
        ReflexScriptPageHandler handler = new ReflexScriptPageHandler();
        KernelScript kScript = new KernelScript();
        try {
            kScript.setCallingContext(DEFINEDUSER);
            handler.setScriptApi(kScript);
            ReflexExecutor.runReflexProgram((String)script, (IReflexHandler)handler, masterParameterMap);
            resp.setCharacterEncoding("UTF-8");
            resp.getWriter().append(handler.getOutput());
            resp.setContentType("text/plain");
            resp.setStatus(200);
        }
        catch (ReflexException re) {
            log.error((Object)handler.getOutput());
            log.error((Object)ExceptionToString.format((Throwable)re));
            Throwable cause = re.getCause();
            if (cause == null) {
                cause = re;
            }
            while (cause.getCause() != null && !(cause instanceof RaptureException)) {
                cause = cause.getCause();
            }
            RaptureException rapEx = cause instanceof RaptureException ? (RaptureException)cause : (re.getMessage() != null ? RaptureExceptionFactory.create((String)("Error calling endpoint: " + re.getMessage()), (Throwable)re) : RaptureExceptionFactory.create((String)"Error calling endpoint", (Throwable)re));
            ErrorWrapper ew = new ErrorWrapper();
            ew.setStatus(rapEx.getStatus());
            ew.setMessage(rapEx.getMessage());
            ew.setId(rapEx.getId());
            this.sendVerboseError(resp, ew);
        }
        resp.flushBuffer();
    }

    private String getScriptUrlFromHttpRequest(HttpServletRequest request) {
        String path = request.getPathInfo();
        if (path == null) {
            return null;
        }
        log.debug((Object)("Path is " + path));
        String[] parts = path.split("/");
        String scriptName = parts[parts.length - 1];
        log.debug((Object)scriptName);
        String scriptURL = this.scriptPrefix + scriptName;
        log.debug((Object)("Script URL is " + scriptURL));
        return scriptURL;
    }

    private void sendVerboseError(HttpServletResponse resp, ErrorWrapper ew) throws IOException {
        Map map = JacksonUtil.getHashFromObject((Object)ew);
        map.put("error", ew.getMessage());
        String r = JacksonUtil.jsonFromObject((Object)map);
        resp.setStatus(500);
        resp.setCharacterEncoding("UTF-8");
        resp.getWriter().append(r);
        resp.setContentType("text/plain");
    }

    protected String getReflexScript(String uri) {
        RaptureURI scriptURI = new RaptureURI(uri);
        RaptureScript script = Kernel.getScript().getScript(DEFINEDUSER, scriptURI.toString());
        if (script != null) {
            return script.getScript();
        }
        log.warn((Object)("Could not locate script for uri - " + scriptURI.toString()));
        return null;
    }

    private Map<String, Object> getRequestVariables(HttpServletRequest req) {
        HashMap<String, Object> serverMap = new HashMap<String, Object>();
        serverMap.put("ContentType", req.getContentType());
        serverMap.put("ContextPath", req.getContextPath());
        serverMap.put("Method", req.getMethod());
        serverMap.put("PathInfo", req.getPathInfo());
        serverMap.put("RemoteAddr", req.getRemoteAddr());
        serverMap.put("Headers", this.getHeaderVariables(req));
        serverMap.put("Attributes", this.getHeaderAttributes(req));
        return serverMap;
    }

    private Map<String, Object> getHeaderVariables(HttpServletRequest req) {
        HashMap<String, Object> headerMap = new HashMap<String, Object>();
        Enumeration headerNames = req.getHeaderNames();
        while (headerNames.hasMoreElements()) {
            String headerName = (String)headerNames.nextElement();
            headerMap.put(headerName, req.getHeader(headerName));
        }
        return headerMap;
    }

    private Map<String, Object> getHeaderAttributes(HttpServletRequest req) {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        Enumeration vars = req.getAttributeNames();
        while (vars.hasMoreElements()) {
            String attrName = (String)vars.nextElement();
            variables.put(attrName, req.getAttribute(attrName));
        }
        return variables;
    }
}

