/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.websocket;

import java.util.HashMap;
import java.util.Map;
import javax.websocket.Session;
import org.apache.log4j.Logger;
import rapture.exchange.TopicMessageHandler;
import rapture.kernel.Kernel;
import rapture.server.web.websocket.SessionState;

public class SessionManager {
    private static Logger logger = Logger.getLogger(SessionManager.class);
    private Map<String, SessionState> sessions = new HashMap<String, SessionState>();

    public void registerSession(Session session) throws Exception {
        if (this.sessions.containsKey(session.getId())) {
            throw new Exception("Session already registered!");
        }
        this.sessions.put(session.getId(), new SessionState(session));
    }

    public void subscribeSession(Session session, String domain, String exchange, String topic) {
        logger.info((Object)("Attempting to subscribe to " + domain + "," + exchange + "," + topic));
        SessionState state = this.sessions.get(session.getId());
        state.setSubscribed(domain, exchange, topic);
        long id = Kernel.getPipeline().getTrusted().subscribeTopic(domain, exchange, topic, (TopicMessageHandler)state);
        state.setSubscriptionId(id);
    }

    public void deregisterSession(Session session) {
        if (this.sessions.get(session.getId()).isSubscribed()) {
            SessionState state = this.sessions.get(session.getId());
            Kernel.getPipeline().getTrusted().unsubscribeTopic(state.getDomain(), state.getExchange(), state.getHandle());
        }
        this.sessions.remove(session.getId());
    }
}

