/*
 * Decompiled with CFR 0.152.
 */
package rapture.server.web.websocket;

import java.io.IOException;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.apache.log4j.Logger;
import rapture.server.web.websocket.SessionManager;

@ServerEndpoint(value="/topic")
public class TopicPublish {
    private static Logger log = Logger.getLogger(TopicPublish.class);
    private static SessionManager manager = new SessionManager();

    @OnOpen
    public void onOpen(Session session) {
        log.info((Object)("Connected ... " + session.getId()));
        try {
            manager.registerSession(session);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @OnMessage
    public String onMessage(String message, Session session) {
        log.info((Object)("Received message " + message));
        if (message.length() >= 4) {
            String code = message.substring(0, 4);
            log.info((Object)("Code is " + code));
            switch (code) {
                case "subs": {
                    String[] parts = message.split(",");
                    if (parts.length != 4) break;
                    manager.subscribeSession(session, parts[1], parts[2], parts[3]);
                    break;
                }
                case "quit": {
                    try {
                        session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.NORMAL_CLOSURE, "Client asked to quit"));
                        break;
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return message;
    }

    @OnClose
    public void onClose(Session session, CloseReason closeReason) {
        log.info((Object)String.format("Session %s closed because of %s", session.getId(), closeReason));
        manager.deregisterSession(session);
    }
}

