/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pickle;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import net.razorvine.pickle.PickleException;

public abstract class PickleUtils {
    public static String readline(InputStream input) throws IOException {
        return PickleUtils.readline(input, false);
    }

    public static String readline(InputStream input, boolean includeLF) throws IOException {
        int c;
        StringBuilder sb = new StringBuilder();
        do {
            if ((c = input.read()) == -1) {
                if (sb.length() == 0) {
                    throw new IOException("premature end of file");
                }
                break;
            }
            if (c == 10 && !includeLF) continue;
            sb.append((char)c);
        } while (c != 10);
        return sb.toString();
    }

    public static short readbyte(InputStream input) throws IOException {
        int b = input.read();
        return (short)b;
    }

    public static byte[] readbytes(InputStream input, int n) throws IOException {
        byte[] buffer = new byte[n];
        PickleUtils.readbytes_into(input, buffer, 0, n);
        return buffer;
    }

    public static byte[] readbytes(InputStream input, long n) throws IOException {
        if (n > Integer.MAX_VALUE) {
            throw new PickleException("pickle too large, can't read more than maxint");
        }
        return PickleUtils.readbytes(input, (int)n);
    }

    public static void readbytes_into(InputStream input, byte[] buffer, int offset, int length) throws IOException {
        while (length > 0) {
            int read = input.read(buffer, offset, length);
            if (read == -1) {
                throw new IOException("expected more bytes in input stream");
            }
            offset += read;
            length -= read;
        }
    }

    public static int bytes_to_integer(byte[] bytes) {
        return PickleUtils.bytes_to_integer(bytes, 0, bytes.length);
    }

    public static int bytes_to_integer(byte[] bytes, int offset, int size) {
        if (size == 2) {
            int i = bytes[1 + offset] & 0xFF;
            i <<= 8;
            return i |= bytes[0 + offset] & 0xFF;
        }
        if (size == 4) {
            int i = bytes[3 + offset];
            i <<= 8;
            i |= bytes[2 + offset] & 0xFF;
            i <<= 8;
            i |= bytes[1 + offset] & 0xFF;
            i <<= 8;
            return i |= bytes[0 + offset] & 0xFF;
        }
        throw new PickleException("invalid amount of bytes to convert to int: " + size);
    }

    public static long bytes_to_long(byte[] bytes, int offset) {
        if (bytes.length - offset < 8) {
            throw new PickleException("too few bytes to convert to long");
        }
        long i = bytes[7 + offset] & 0xFF;
        i <<= 8;
        i |= (long)(bytes[6 + offset] & 0xFF);
        i <<= 8;
        i |= (long)(bytes[5 + offset] & 0xFF);
        i <<= 8;
        i |= (long)(bytes[4 + offset] & 0xFF);
        i <<= 8;
        i |= (long)(bytes[3 + offset] & 0xFF);
        i <<= 8;
        i |= (long)(bytes[2 + offset] & 0xFF);
        i <<= 8;
        i |= (long)(bytes[1 + offset] & 0xFF);
        i <<= 8;
        return i |= (long)(bytes[offset] & 0xFF);
    }

    public static long bytes_to_uint(byte[] bytes, int offset) {
        if (bytes.length - offset < 4) {
            throw new PickleException("too few bytes to convert to long");
        }
        long i = bytes[3 + offset] & 0xFF;
        i <<= 8;
        i |= (long)(bytes[2 + offset] & 0xFF);
        i <<= 8;
        i |= (long)(bytes[1 + offset] & 0xFF);
        i <<= 8;
        return i |= (long)(bytes[0 + offset] & 0xFF);
    }

    public static byte[] integer_to_bytes(int i) {
        byte[] b = new byte[]{(byte)(i & 0xFF), (byte)((i >>= 8) & 0xFF), (byte)((i >>= 8) & 0xFF), (byte)((i >>= 8) & 0xFF)};
        return b;
    }

    public static byte[] double_to_bytes(double d) {
        long bits = Double.doubleToRawLongBits(d);
        byte[] b = new byte[8];
        b[7] = (byte)(bits & 0xFFL);
        b[6] = (byte)((bits >>= 8) & 0xFFL);
        b[5] = (byte)((bits >>= 8) & 0xFFL);
        b[4] = (byte)((bits >>= 8) & 0xFFL);
        b[3] = (byte)((bits >>= 8) & 0xFFL);
        b[2] = (byte)((bits >>= 8) & 0xFFL);
        b[1] = (byte)((bits >>= 8) & 0xFFL);
        b[0] = (byte)((bits >>= 8) & 0xFFL);
        return b;
    }

    public static double bytes_to_double(byte[] bytes, int offset) {
        try {
            long result = bytes[0 + offset] & 0xFF;
            result <<= 8;
            result |= (long)(bytes[1 + offset] & 0xFF);
            result <<= 8;
            result |= (long)(bytes[2 + offset] & 0xFF);
            result <<= 8;
            result |= (long)(bytes[3 + offset] & 0xFF);
            result <<= 8;
            result |= (long)(bytes[4 + offset] & 0xFF);
            result <<= 8;
            result |= (long)(bytes[5 + offset] & 0xFF);
            result <<= 8;
            result |= (long)(bytes[6 + offset] & 0xFF);
            result <<= 8;
            return Double.longBitsToDouble(result |= (long)(bytes[7 + offset] & 0xFF));
        }
        catch (ArrayIndexOutOfBoundsException x) {
            throw new PickleException("decoding double: too few bytes");
        }
    }

    public static float bytes_to_float(byte[] bytes, int offset) {
        try {
            int result = bytes[0 + offset] & 0xFF;
            result <<= 8;
            result |= bytes[1 + offset] & 0xFF;
            result <<= 8;
            result |= bytes[2 + offset] & 0xFF;
            result <<= 8;
            return Float.intBitsToFloat(result |= bytes[3 + offset] & 0xFF);
        }
        catch (ArrayIndexOutOfBoundsException x) {
            throw new PickleException("decoding float: too few bytes");
        }
    }

    public static Number decode_long(byte[] data) {
        if (data.length == 0) {
            return 0L;
        }
        byte[] data2 = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            data2[data.length - i - 1] = data[i];
        }
        BigInteger bigint = new BigInteger(data2);
        return PickleUtils.optimizeBigint(bigint);
    }

    public static byte[] encode_long(BigInteger big) {
        byte[] data = big.toByteArray();
        byte[] data2 = new byte[data.length];
        for (int i = 0; i < data.length; ++i) {
            data2[data.length - i - 1] = data[i];
        }
        return data2;
    }

    public static Number optimizeBigint(BigInteger bigint) {
        BigInteger MAXLONG = BigInteger.valueOf(Long.MAX_VALUE);
        BigInteger MINLONG = BigInteger.valueOf(Long.MIN_VALUE);
        switch (bigint.signum()) {
            case 0: {
                return 0L;
            }
            case 1: {
                if (bigint.compareTo(MAXLONG) > 0) break;
                return bigint.longValue();
            }
            case -1: {
                if (bigint.compareTo(MINLONG) < 0) break;
                return bigint.longValue();
            }
        }
        return bigint;
    }

    public static String rawStringFromBytes(byte[] data) {
        StringBuilder str = new StringBuilder(data.length);
        for (byte b : data) {
            str.append((char)(b & 0xFF));
        }
        return str.toString();
    }

    public static byte[] str2bytes(String str) throws IOException {
        byte[] b = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c > '\u00ff') {
                throw new UnsupportedEncodingException("string contained a char > 255, cannot convert to bytes");
            }
            b[i] = (byte)c;
        }
        return b;
    }

    public static String decode_escaped(String str) {
        if (str.indexOf(92) == -1) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                char c2 = str.charAt(++i);
                switch (c2) {
                    case '\\': {
                        sb.append(c);
                        break;
                    }
                    case 'x': {
                        char h1 = str.charAt(++i);
                        char h2 = str.charAt(++i);
                        c2 = (char)Integer.parseInt("" + h1 + h2, 16);
                        sb.append(c2);
                        break;
                    }
                    default: {
                        throw new PickleException("invalid escape sequence in string");
                    }
                }
                continue;
            }
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }

    public static String decode_unicode_escaped(String str) {
        if (str.indexOf(92) == -1) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\\') {
                char c2 = str.charAt(++i);
                switch (c2) {
                    case '\\': {
                        sb.append(c);
                        break;
                    }
                    case 'u': {
                        char h1 = str.charAt(++i);
                        char h2 = str.charAt(++i);
                        char h3 = str.charAt(++i);
                        char h4 = str.charAt(++i);
                        c2 = (char)Integer.parseInt("" + h1 + h2 + h3 + h4, 16);
                        sb.append(c2);
                        break;
                    }
                    default: {
                        throw new PickleException("invalid escape sequence in string");
                    }
                }
                continue;
            }
            sb.append(str.charAt(i));
        }
        return sb.toString();
    }
}

