/*
 * Decompiled with CFR 0.152.
 */
package net.razorvine.pyro;

import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.razorvine.pyro.PyroException;

public class PyroURI
implements Serializable {
    private static final long serialVersionUID = -7611447798373262153L;
    public String protocol = "PYRO";
    public String objectid;
    public String host;
    public int port;

    public PyroURI() {
    }

    public PyroURI(PyroURI other) {
        this.protocol = other.protocol;
        this.objectid = other.objectid;
        this.host = other.host;
        this.port = other.port;
    }

    public PyroURI(String uri) {
        Pattern p = Pattern.compile("(PYRO[A-Z]*):(\\S+?)(@(\\S+))?$");
        Matcher m = p.matcher(uri);
        if (!m.find()) {
            throw new PyroException("invalid URI string");
        }
        this.protocol = m.group(1);
        this.objectid = m.group(2);
        String[] loc = m.group(4).split(":");
        this.host = loc[0];
        this.port = Integer.parseInt(loc[1]);
    }

    public PyroURI(String objectid, String host, int port) {
        this.objectid = objectid;
        this.host = host;
        this.port = port;
    }

    public String toString() {
        return "<PyroURI " + this.protocol + ":" + this.objectid + "@" + this.host + ":" + this.port + ">";
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PyroURI)) {
            return false;
        }
        PyroURI other = (PyroURI)obj;
        return this.toString().equals(other.toString());
    }
}

