/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import net.rcarz.jiraclient.ICredentials;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.sf.json.JSON;
import net.sf.json.JSONObject;
import org.apache.http.HttpRequest;

public class TokenCredentials
implements ICredentials {
    private String username;
    private String password;
    private String token;
    private String cookieName = "JSESSIONID";

    public TokenCredentials(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public TokenCredentials(String jsessionId) {
        this.token = jsessionId;
    }

    @Override
    public void authenticate(HttpRequest req) {
        if (this.token != null) {
            req.addHeader("Cookie", this.cookieName + "=" + this.token + ";");
        }
    }

    @Override
    public String getLogonName() {
        return this.username;
    }

    @Override
    public void initialize(RestClient client) throws JiraException {
        if (this.token == null) {
            try {
                JSONObject req = new JSONObject();
                req.put((Object)"username", (Object)this.username);
                req.put((Object)"password", (Object)this.password);
                JSON json = client.post(Resource.getAuthUri() + "session", (JSON)req);
                if (json instanceof JSONObject) {
                    JSONObject jso = (JSONObject)json;
                    jso = (JSONObject)jso.get("session");
                    this.cookieName = (String)jso.get("name");
                    this.token = (String)jso.get("value");
                }
            }
            catch (Exception ex) {
                throw new JiraException("Failed to login", ex);
            }
        }
    }

    @Override
    public void logout(RestClient client) throws JiraException {
        if (this.token != null) {
            try {
                client.delete(Resource.getAuthUri() + "session");
            }
            catch (Exception e) {
                throw new JiraException("Failed to logout", e);
            }
        }
    }

    public String getToken() {
        return this.token;
    }
}

