/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient.agile;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.RestClient;
import net.sf.json.JSON;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.math.NumberUtils;

public abstract class AgileResource {
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_SELF = "self";
    public static final String RESOURCE_URI = "/rest/agile/1.0/";
    private RestClient restclient = null;
    private long id = 0L;
    private String name;
    private String self;
    private JSONObject attributes = new JSONObject();

    public AgileResource(RestClient restclient, JSONObject json) throws JiraException {
        this.restclient = restclient;
        if (json != null) {
            this.deserialize(json);
        }
    }

    protected static <T extends AgileResource> T getResource(Class<T> type, Object r, RestClient restclient) throws JiraException {
        if (!(r instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        AgileResource result = null;
        if (!((JSONObject)r).isNullObject()) {
            try {
                Constructor<T> constructor = type.getDeclaredConstructor(RestClient.class, JSONObject.class);
                result = (AgileResource)constructor.newInstance(restclient, r);
            }
            catch (Exception e) {
                throw new JiraException("Failed to deserialize object.", e);
            }
        }
        return (T)result;
    }

    protected static <T extends AgileResource> List<T> getResourceArray(Class<T> type, Object ra, RestClient restclient, String listName) throws JiraException {
        if (!(ra instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        JSONObject jo = (JSONObject)ra;
        if (!jo.containsKey((Object)listName) || !(jo.get(listName) instanceof JSONArray)) {
            throw new JiraException("No array found for name '" + listName + "'");
        }
        ArrayList<T> results = new ArrayList<T>();
        for (Object v : (JSONArray)jo.get(listName)) {
            T item = AgileResource.getResource(type, v, restclient);
            if (item == null) continue;
            results.add(item);
        }
        return results;
    }

    static <T extends AgileResource> List<T> list(RestClient restclient, Class<T> type, String url) throws JiraException {
        return AgileResource.list(restclient, type, url, "values");
    }

    static <T extends AgileResource> List<T> list(RestClient restclient, Class<T> type, String url, String listName) throws JiraException {
        JSON result;
        try {
            result = restclient.get(url);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve a list of " + type.getSimpleName() + " : " + url, ex);
        }
        return AgileResource.getResourceArray(type, result, restclient, listName);
    }

    static <T extends AgileResource> T get(RestClient restclient, Class<T> type, String url) throws JiraException {
        JSON result;
        try {
            result = restclient.get(url);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve " + type.getSimpleName() + " : " + url, ex);
        }
        return AgileResource.getResource(type, result, restclient);
    }

    <T extends AgileResource> List<T> getSubResourceArray(Class<T> type, JSONObject subJson, String resourceName) throws JiraException {
        List<T> result = null;
        if (subJson.containsKey((Object)resourceName)) {
            result = AgileResource.getResourceArray(type, subJson.get(resourceName), this.getRestclient(), resourceName + "s");
        }
        return result;
    }

    <T extends AgileResource> T getSubResource(Class<T> type, JSONObject subJson, String resourceName) throws JiraException {
        T result = null;
        if (subJson.containsKey((Object)resourceName) && !subJson.get(resourceName).equals("null")) {
            result = AgileResource.getResource(type, subJson.get(resourceName), this.getRestclient());
        }
        return result;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getSelfURL() {
        return this.self;
    }

    protected RestClient getRestclient() {
        return this.restclient;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    void deserialize(JSONObject json) throws JiraException {
        this.id = this.getLong(json.get(ATTR_ID));
        this.name = Field.getString(json.get(ATTR_NAME));
        this.self = Field.getString(json.get(ATTR_SELF));
        this.addAttributes(json);
    }

    void addAttributes(JSONObject json) {
        this.attributes.putAll((Map)json);
    }

    long getLong(Object o) {
        if (o instanceof Integer || o instanceof Long) {
            return Field.getLong(o);
        }
        if (o instanceof String && NumberUtils.isDigits((String)((String)o))) {
            return NumberUtils.toLong((String)((String)o), (long)0L);
        }
        return 0L;
    }

    public String toString() {
        return String.format("%s{id=%s, name='%s'}", this.getClass().getSimpleName(), this.id, this.name);
    }
}

