/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient.agile;

import java.util.List;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.agile.AgileResource;
import net.rcarz.jiraclient.agile.Epic;
import net.rcarz.jiraclient.agile.Issue;
import net.rcarz.jiraclient.agile.Sprint;
import net.sf.json.JSONObject;

public class Board
extends AgileResource {
    private String type;

    protected Board(RestClient restclient, JSONObject json) throws JiraException {
        super(restclient, json);
    }

    public static Board get(RestClient restclient, long id) throws JiraException {
        return AgileResource.get(restclient, Board.class, "/rest/agile/1.0/board/" + id);
    }

    public static List<Board> getAll(RestClient restclient) throws JiraException {
        return AgileResource.list(restclient, Board.class, "/rest/agile/1.0/board");
    }

    @Override
    protected void deserialize(JSONObject json) throws JiraException {
        super.deserialize(json);
        this.type = Field.getString(json.get("type"));
    }

    public String getType() {
        return this.type;
    }

    public List<Sprint> getSprints() throws JiraException {
        return Sprint.getAll(this.getRestclient(), this.getId());
    }

    public List<Issue> getBacklog() throws JiraException {
        return AgileResource.list(this.getRestclient(), Issue.class, "/rest/agile/1.0/board/" + this.getId() + "/backlog", "issues");
    }

    public List<Issue> getIssuesWithoutEpic() throws JiraException {
        return AgileResource.list(this.getRestclient(), Issue.class, "/rest/agile/1.0/board/" + this.getId() + "/epic/none/issue", "issues");
    }

    public List<Epic> getEpics() throws JiraException {
        return AgileResource.list(this.getRestclient(), Epic.class, "/rest/agile/1.0/board/" + this.getId() + "/epic");
    }
}

