/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient.agile;

import java.util.List;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.agile.AgileResource;
import net.rcarz.jiraclient.agile.Issue;
import net.sf.json.JSONObject;

public class Epic
extends AgileResource {
    private Issue issue;
    private String key;
    private String summary;
    private boolean done;

    public Epic(RestClient restclient, JSONObject json) throws JiraException {
        super(restclient, json);
    }

    public static Epic get(RestClient restclient, long id) throws JiraException {
        return AgileResource.get(restclient, Epic.class, "/rest/agile/1.0/epic/" + id);
    }

    public Issue asIssue(boolean refresh) throws JiraException {
        if (this.issue == null || refresh) {
            this.issue = Issue.get(this.getRestclient(), this.getId());
        }
        return this.issue;
    }

    public List<Issue> getIssues() throws JiraException {
        return AgileResource.list(this.getRestclient(), Issue.class, "/rest/agile/1.0/epic/" + this.getId() + "/issue", "issues");
    }

    @Override
    void deserialize(JSONObject json) throws JiraException {
        super.deserialize(json);
        this.key = Field.getString(json.get("key"));
        this.summary = Field.getString(json.get("summary"));
        this.done = Field.getBoolean(json.get("done"));
    }

    public String getKey() {
        return this.key;
    }

    public String getSummary() {
        return this.summary;
    }

    public boolean isDone() {
        return this.done;
    }
}

