/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient.agile;

import java.util.Date;
import java.util.List;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.agile.AgileResource;
import net.rcarz.jiraclient.agile.Comment;
import net.rcarz.jiraclient.agile.Epic;
import net.rcarz.jiraclient.agile.IssueType;
import net.rcarz.jiraclient.agile.Priority;
import net.rcarz.jiraclient.agile.Project;
import net.rcarz.jiraclient.agile.Resolution;
import net.rcarz.jiraclient.agile.Sprint;
import net.rcarz.jiraclient.agile.Status;
import net.rcarz.jiraclient.agile.TimeTracking;
import net.rcarz.jiraclient.agile.User;
import net.rcarz.jiraclient.agile.Worklog;
import net.sf.json.JSONObject;

public class Issue
extends AgileResource {
    private String key;
    private boolean flagged;
    private Sprint sprint;
    private List<Sprint> closedSprints;
    private String description;
    private Project project;
    private List<Comment> comments;
    private Epic epic;
    private List<Worklog> worklogs;
    private TimeTracking timeTracking;
    private IssueType issueType;
    private Status status;
    private Resolution resolution;
    private Date created;
    private Date updated;
    private Priority priority;
    private User assignee;
    private User creator;
    private User reporter;
    private String environment;

    public Issue(RestClient restclient, JSONObject json) throws JiraException {
        super(restclient, json);
    }

    public static Issue get(RestClient restclient, long id) throws JiraException {
        return AgileResource.get(restclient, Issue.class, "/rest/agile/1.0/issue/" + id);
    }

    public static Issue get(RestClient restclient, String key) throws JiraException {
        return AgileResource.get(restclient, Issue.class, "/rest/agile/1.0/issue/" + key);
    }

    @Override
    protected void deserialize(JSONObject json) throws JiraException {
        super.deserialize(json);
        this.key = Field.getString(json.get("key"));
        if (json.containsKey((Object)"fields")) {
            JSONObject fields = (JSONObject)json.get("fields");
            this.setName(Field.getString(fields.get("summary")));
            this.flagged = Field.getBoolean(fields.get("flagged"));
            this.sprint = this.getSubResource(Sprint.class, fields, "sprint");
            this.closedSprints = this.getSubResourceArray(Sprint.class, fields, "closedSprint");
            this.description = Field.getString(fields.get("description"));
            this.project = this.getSubResource(Project.class, fields, "project");
            this.comments = this.getSubResourceArray(Comment.class, fields, "comment");
            this.epic = this.getSubResource(Epic.class, fields, "epic");
            this.worklogs = this.getSubResourceArray(Worklog.class, fields, "worklog");
            this.timeTracking = this.getSubResource(TimeTracking.class, fields, "timetracking");
            this.environment = Field.getString(fields.get("environment"));
            this.issueType = this.getSubResource(IssueType.class, fields, "issuetype");
            this.status = this.getSubResource(Status.class, fields, "status");
            this.resolution = this.getSubResource(Resolution.class, fields, "resolution");
            this.created = Field.getDateTime(fields.get("created"));
            this.updated = Field.getDateTime(fields.get("updated"));
            this.priority = this.getSubResource(Priority.class, fields, "priority");
            this.assignee = this.getSubResource(User.class, fields, "assignee");
            this.creator = this.getSubResource(User.class, fields, "creator");
            this.reporter = this.getSubResource(User.class, fields, "reporter");
            this.addAttributes(fields);
        }
    }

    public String getKey() {
        return this.key;
    }

    public boolean isFlagged() {
        return this.flagged;
    }

    public Sprint getSprint() {
        return this.sprint;
    }

    public List<Sprint> getClosedSprints() {
        return this.closedSprints;
    }

    public String getDescription() {
        return this.description;
    }

    public Project getProject() {
        return this.project;
    }

    public List<Comment> getComments() {
        return this.comments;
    }

    public Epic getEpic() {
        return this.epic;
    }

    public List<Worklog> getWorklogs() {
        return this.worklogs;
    }

    public TimeTracking getTimeTracking() {
        return this.timeTracking;
    }

    public IssueType getIssueType() {
        return this.issueType;
    }

    public Status getStatus() {
        return this.status;
    }

    public Resolution getResolution() {
        return this.resolution;
    }

    public Date getCreated() {
        return this.created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public Priority getPriority() {
        return this.priority;
    }

    public User getAssignee() {
        return this.assignee;
    }

    public User getCreator() {
        return this.creator;
    }

    public User getReporter() {
        return this.reporter;
    }

    public String getEnvironment() {
        return this.environment;
    }
}

