/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient.agile;

import java.util.Date;
import java.util.List;
import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.agile.AgileResource;
import net.rcarz.jiraclient.agile.Issue;
import net.sf.json.JSONObject;

public class Sprint
extends AgileResource {
    private String state;
    private long originBoardId;
    private Date startDate;
    private Date endDate;
    private Date completeDate;

    protected Sprint(RestClient restclient, JSONObject json) throws JiraException {
        super(restclient, json);
    }

    public static Sprint get(RestClient restclient, long sprintId) throws JiraException {
        return AgileResource.get(restclient, Sprint.class, "/rest/agile/1.0/sprint/" + sprintId);
    }

    public static List<Sprint> getAll(RestClient restclient, long boardId) throws JiraException {
        return AgileResource.list(restclient, Sprint.class, "/rest/agile/1.0/board/" + boardId + "/sprint");
    }

    public List<Issue> getIssues() throws JiraException {
        return AgileResource.list(this.getRestclient(), Issue.class, "/rest/agile/1.0/sprint/" + this.getId() + "/issue", "issues");
    }

    @Override
    protected void deserialize(JSONObject json) throws JiraException {
        super.deserialize(json);
        this.state = Field.getString(json.get("state"));
        this.originBoardId = this.getLong(json.get("originBoardId"));
        this.startDate = Field.getDateTime(json.get("startDate"));
        this.endDate = Field.getDateTime(json.get("endDate"));
        this.completeDate = Field.getDateTime(json.get("completeDate"));
    }

    public String getState() {
        return this.state;
    }

    public long getOriginBoardId() {
        return this.originBoardId;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public Date getCompleteDate() {
        return this.completeDate;
    }
}

