/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient.agile;

import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.RestClient;
import net.rcarz.jiraclient.agile.AgileResource;
import net.sf.json.JSONObject;

public class TimeTracking
extends AgileResource {
    private String originalEstimate;
    private String remainingEstimate;
    private String timeSpent;
    private long originalEstimateSeconds;
    private long remainingEstimateSeconds;
    private long timeSpentSeconds;

    public TimeTracking(RestClient restclient, JSONObject json) throws JiraException {
        super(restclient, json);
    }

    @Override
    void deserialize(JSONObject json) throws JiraException {
        super.deserialize(json);
        this.originalEstimate = Field.getString(json.get("originalEstimate"));
        this.remainingEstimate = Field.getString(json.get("remainingEstimate"));
        this.timeSpent = Field.getString(json.get("timeSpent"));
        this.originalEstimateSeconds = Field.getLong(json.get("originalEstimateSeconds"));
        this.remainingEstimateSeconds = Field.getLong(json.get("remainingEstimateSeconds"));
        this.timeSpentSeconds = Field.getLong(json.get("timeSpentSeconds"));
    }

    @Override
    public String toString() {
        return String.format("%s{original='%s', remaining='%s', timeSpent='%s'}", this.getClass().getSimpleName(), this.getOriginalEstimate(), this.getRemainingEstimate(), this.getTimeSpent());
    }

    public String getOriginalEstimate() {
        return this.originalEstimate;
    }

    public String getRemainingEstimate() {
        return this.remainingEstimate;
    }

    public String getTimeSpent() {
        return this.timeSpent;
    }

    public long getOriginalEstimateSeconds() {
        return this.originalEstimateSeconds;
    }

    public long getRemainingEstimateSeconds() {
        return this.remainingEstimateSeconds;
    }

    public long getTimeSpentSeconds() {
        return this.timeSpentSeconds;
    }
}

