/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.jiraclient;

import net.rcarz.jiraclient.Field;
import net.rcarz.jiraclient.Issue;
import net.rcarz.jiraclient.JiraException;
import net.rcarz.jiraclient.LinkType;
import net.rcarz.jiraclient.Resource;
import net.rcarz.jiraclient.RestClient;
import net.sf.json.JSON;
import net.sf.json.JSONObject;

public class IssueLink
extends Resource {
    private LinkType type = null;
    private Issue inwardIssue = null;
    private Issue outwardIssue = null;

    protected IssueLink(RestClient restclient, JSONObject json) {
        super(restclient);
        if (json != null) {
            this.deserialise(json);
        }
    }

    private void deserialise(JSONObject json) {
        JSONObject map = json;
        this.self = Field.getString(map.get("self"));
        this.id = Field.getString(map.get("id"));
        this.type = Field.getResource(LinkType.class, map.get("type"), this.restclient);
        this.outwardIssue = Field.getResource(Issue.class, map.get("outwardIssue"), this.restclient);
        this.inwardIssue = Field.getResource(Issue.class, map.get("inwardIssue"), this.restclient);
    }

    public void delete() throws JiraException {
        try {
            this.restclient.delete(IssueLink.getBaseUri() + "issueLink/" + this.id);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to delete issue link " + this.id, ex);
        }
    }

    public static IssueLink get(RestClient restclient, String id) throws JiraException {
        JSON result = null;
        try {
            result = restclient.get(IssueLink.getBaseUri() + "issueLink/" + id);
        }
        catch (Exception ex) {
            throw new JiraException("Failed to retrieve issue link " + id, ex);
        }
        if (!(result instanceof JSONObject)) {
            throw new JiraException("JSON payload is malformed");
        }
        return new IssueLink(restclient, (JSONObject)result);
    }

    public String toString() {
        return String.format("%s %s", this.getType().getInward(), this.getOutwardIssue());
    }

    public LinkType getType() {
        return this.type;
    }

    public Issue getOutwardIssue() {
        return this.outwardIssue;
    }

    public Issue getInwardIssue() {
        return this.inwardIssue;
    }
}

