/*
 * Decompiled with CFR 0.152.
 */
package net.rcarz.utils;

import org.joda.time.DurationFieldType;
import org.joda.time.Period;
import org.joda.time.PeriodType;

public class WorklogUtils {
    public static String formatDurationFromSeconds(long durationInSeconds) {
        if (durationInSeconds < 60L) {
            return "0m";
        }
        StringBuilder builder = new StringBuilder();
        PeriodType type = PeriodType.forFields((DurationFieldType[])new DurationFieldType[]{DurationFieldType.hours(), DurationFieldType.minutes()});
        Period period = new Period(1000L * durationInSeconds, type);
        if (period.getHours() != 0) {
            builder.append(period.getHours()).append("h").append(" ");
        }
        if (period.getMinutes() != 0) {
            builder.append(period.getMinutes()).append("m").append(" ");
        }
        if (builder.length() > 0 && builder.charAt(builder.length() - 1) == " ".charAt(0)) {
            builder.deleteCharAt(builder.length() - 1);
        }
        return builder.toString();
    }
}

