/*
 * Copyright 2009-2010 Nanjing RedOrange ltd (http://www.red-orange.cn)
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package redora.generator;

import org.apache.commons.io.filefilter.SuffixFileFilter;

import java.io.File;

import static java.io.File.separatorChar;

/**
 * Some rigid and static locations of several files and directories. The baseProjectDir
 * parameter can add a directory prefix.
 * 
 * @author Nanjing RedOrange (http://www.red-orange.cn)
 */
public class FileLocations {

    /** target (set by Maven) */
    public final String buildDir;
    /** src/main/java */
    public final String sourceDir;
    /** src/main/resources */
    public final String resourceDir;
    /** ../resources/application.xml */
    public final String applicationFile;
    /** ../resources/model */
    public final String modelDir;
    /** ../resources/model/includes */
    public final String includeDir;
    /** ../resources/upgrade */
    public final String upgradeDir;
    /** ~/redora */
    public final String redoraDir;
    /* target/generated-resources */
    public final String templatesDir;

    /** src/main/resources/templates/ */
    //public final String localTemplatesDir;

    public FileLocations(String buildDir, String artifactId) throws ModelGenerationException {
        this.buildDir = buildDir;
        this.templatesDir = buildDir + separatorChar + "generated-resources";
        String src = "src";
        String md = src + separatorChar + "main" + separatorChar + "resources" + separatorChar + "model";
        if (!new File(md).exists() || new File(md).list(new SuffixFileFilter(".xml")).length == 0) {
            //Using a maven module. Prefix with the artifactId
            src = artifactId + separatorChar + src;
            md = artifactId + separatorChar + md;
            if (!new File(md).exists() || new File(md).list(new SuffixFileFilter(".xml")).length == 0)
                throw new ModelGenerationException("Can't find project root: " + new File(md).getAbsolutePath());
        }
        modelDir = md;
        resourceDir = src + separatorChar + "main" + separatorChar + "resources";
        applicationFile = resourceDir + separatorChar + "application.xml";
        sourceDir = src + separatorChar + "main" + separatorChar + "java";
        includeDir = modelDir + separatorChar + "includes";
        upgradeDir = resourceDir + separatorChar + "upgrade";
        redoraDir = System.getProperty("user.home") + separatorChar + ".redora";
    }

    @Override
    public String toString() {
        return new StringBuilder().append("modelDir: ").append(modelDir)
                .append(", applicationDir: ").append(applicationFile)
                .append(", sourceDir: ").append(sourceDir)
                .append(", redoraDir: ").append(redoraDir).toString();
    }
}
